/*  A sample program to show how to use the progress meter.
    The program wil display a small dialog allowing the
    user to enter a filename. The program will then count
    the number of "eight" bit characters in the file,
    while displaying the state of the operation.

    Copyright by Thomas Ravnholt 1993
    test.c is shareware - read progress.txt for further information.
*/

#include <windows.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include "progress.h"
#include "test.h"

HANDLE  ghInst;                         // Program instance handle
HWND  progress_hwnd;

char szFileName[MAXFILENAME];
char szFileTitle[MAXFILENAME];

OPENFILENAME FAR ofn =
{
  0, 0, 0, "All Files (*.*)\0*.*\0", NULL, 0, 1, szFileName,
  MAXFILENAME, szFileTitle, MAXFILENAME, NULL, "All", 0, 0, 0, "*", 0, 0
};

int PASCAL WinMain(
    HINSTANCE  hInst,		   
    HINSTANCE  hPrev,		   
    LPSTR   lpszCmdLine,   
    int     iCmdShow )     
{
    FARPROC  fpfn;

    /* Save instance handle for dialog boxes */
    ghInst = hInst;

    fpfn = MakeProcInstance((FARPROC)TestDlgProc, ghInst);
    DialogBox(ghInst, MAKEINTRESOURCE(TEST), NULL, (DLGPROC)fpfn);
    FreeProcInstance(fpfn);

    return TRUE;
}

BOOL FAR PASCAL TestDlgProc(
    HWND     hwnd,           
    unsigned wMsg,           
    WORD     wParam,         
    LONG     lParam )        
{
    FARPROC lpProcAbout;

    switch (wMsg)
    {
        case WM_INITDIALOG:
            /* Create a progress meter in the dialog hwnd */
            progress_hwnd=CreateProgress(hwnd,ghInst,20, 50, 400, 16);
            return TRUE;
        case WM_CLOSE:
            /* If the user choose to exit  then destroy the 
               progress meter and close down */           
            DestroyProgress(progress_hwnd);
            EndDialog(hwnd, TRUE);
            break;
        case WM_COMMAND:
            switch (wParam)
            {
                case IDDB_EXIT:
                    /* If the user choose to exit  then destroy the 
                       progress meter and close down */           
                    DestroyProgress(progress_hwnd);
                    EndDialog(hwnd, TRUE);
                    break;
                case IDDB_ABOUT:
                    lpProcAbout = MakeProcInstance((FARPROC)About, ghInst);
                    DialogBox(ghInst,
                              "AboutBox",
                              hwnd,
                              (DLGPROC)lpProcAbout);
                    FreeProcInstance(lpProcAbout);
                    break;
                case IDDB_OPEN:
                {
                   int      file;
                   unsigned char    c;
                   long     length,count=0,position;
                   char     buf[MAXFILENAME];

                   /* Let the user choose a file */
                   strcpy(buf,GetFile(hwnd,&ofn));

                   if ((file=_open(buf,_O_RDONLY|_O_BINARY)) == -1)
                   {
                     strcpy(buf, "Unable to open file");
                     MessageBox(hwnd, buf, "Error", MB_OK | MB_ICONEXCLAMATION);
                     return FALSE;
                   }
                   else
                   {
			               SetWindowText(GetDlgItem(hwnd, IDDT_EDIT),"Counting eight bit charaters");
                     SendMessage(GetDlgItem(hwnd,IDDT_EDIT),WM_PAINT,0,0L);

                     ClearProgress(progress_hwnd);
                     length=_filelength(file);
                     position=0;
                     while(_read(file,&c,1)>0)
                     {
                       if(c>127)
                         count++;
                        position++;
                        UpdateProgress(progress_hwnd,GetStockObject(LTGRAY_BRUSH),position,length);
                     }
                     UpdateProgress(progress_hwnd,GetStockObject(LTGRAY_BRUSH),position,length);

                     sprintf(buf,"The file contained %ld eight bit characters",count); 
			               SetWindowText(GetDlgItem(hwnd, IDDT_EDIT),buf);
                     _close(file);
                   }
                }
                break;
            }
            break;
    }
    return FALSE;
}


char * GetFile(HWND hwnd,OPENFILENAME FAR *ofn)
{
  ofn->hwndOwner = hwnd;
  ofn->lStructSize = sizeof(OPENFILENAME);
  ofn->Flags = OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY;

  if (!GetOpenFileName((LPOPENFILENAME)ofn))
  {
    return NULL;
  }

  return ofn->lpstrFile;
}

BOOL FAR PASCAL About(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
    switch (message) 
    {
        case WM_INITDIALOG:
            return (TRUE);

        case WM_COMMAND:
            if (wParam == IDOK || wParam == IDCANCEL) 
            {
                EndDialog(hDlg, TRUE);
                return (TRUE);
            }
            break;
    }
    return (FALSE);
}

