PROGRAM HtDemo;

USES HtScreen;

VAR Screen : ARRAY[1..50,1..80] OF WORD;
    MidRow,
    MidCol : BYTE;


PROCEDURE QuitProgram;
BEGIN
  HtFill(1,1,25,80,White+BlackBG,' ');
  GoToRC(1,1);
  SetCursor(CursorInitial);
  Halt(1);
END;


PROCEDURE PressAnyKey(Row : BYTE);
VAR C : CHAR;
BEGIN
  SetCursor(CursorOff);
  HtWriteC(Row,MidCol,Yellow+Blink+RedBG,' Press any key... ');
  C := HtReadKey(Fk);
  IF C=#27 THEN QuitProgram;
END;


PROCEDURE PageOne;
VAR I : WORD;
BEGIN
  Explode(2,2,23,78,White+BlueBG,SingleBorder);
  HtWriteC(MidRow-1,MidCol,Yellow+BlueBG,'Screen Utilities');
  HtWriteC(MidRow+1,MidCol,SameAttr,'for Turbo Pascal 5.5');
  PressAnyKey(CRTRows);
  FOR I := 1 TO 1000 DO
    HtFill(2+Random(10),2+Random(CRTCols-30),1+Random(CRTRows-11),1+Random(29),Random($7F),Chr(30+Random(50)));
  Explode(MidRow-3,20,8,40,White+RedBG,DTopSSide);
  HtWrite(MidRow-2,32,Yellow+RedBG,'Screen Utilities');
  HtWrite(MidRow-1,30,Yellow+RedBG,'for Turbo Pascal 5.5');
  HtWrite(MidRow+1,22,White+RedBG,'The program just showed you a 1000(!)');
  HtWrite(MidRow+2,22,White+RedBG,'randomly attributed rectangular boxes');
  HtWrite(MidRow+3,22,White+RedBG,'filled with random characters.');
  HtStoreToMem(1,1,CrtRows,CrtCols,Screen);
  PressAnyKey(CrtRows);
  FOR I := 1 TO 5000 DO
    HtWrite(1+Random(CRTRows),1+Random(CRTCols),$00,' ');
END;


PROCEDURE PageTwo;
BEGIN
  Box(2,2,23,78,White+BlueBG,SingleBorder,' ');
  HtWriteC(5,MidCol,White+BlueBG,'Screen Utilities');
  HtWriteC(6,MidCol,White+BlueBG,'for Turbo Pascal 5.5');
  HtWrite(8,8,White+BlueBG,'The Screen Utilities contains some 25 functions and procedures to');
  HtWrite(9,8,White+BlueBG,'simplify the use of text screens in Turbo Pascal 5.5.');
  HtWrite(11,8,White+BlueBG,'There are procedures to');
  HtWrite(12,8,White+BlueBG,'  - control the cursor size and position');
  HtWrite(13,8,White+BlueBG,'  - read the character and attributes at a specified location');
  HtWrite(14,8,White+BlueBG,'  - write a string at specified position with specified attributes');
  HtWrite(15,8,White+BlueBG,'  - change the attributes of an area of the screen');
  HtWrite(16,8,White+BlueBG,'  - fill an area of the screen with a specifies character');
  HtWrite(17,8,White+BlueBG,'  - scroll an area of the screen up or down');
  HtWrite(18,8,White+BlueBG,'  - store to memory an area of the screen');
  HtWrite(19,8,White+BlueBG,'  - add shadow to a box');
  HtWrite(20,8,White+BlueBG,'  - get and set the video mode');
  HtWrite(21,8,White+BlueBG,'  - get and set the number of rows (25 or 43/50)');
  PressAnyKey(CRTRows);
END;


PROCEDURE PageThree;
VAR I : WORD;
    S : STRING;
BEGIN
  Box(2,2,23,78,White+BlueBG,SingleBorder,' ');
  HtWriteC(3,MidCol,White+BlueBG,'Screen Utilities');
  HtWriteC(4,MidCol,White+BlueBG,'for Turbo Pascal 5.5');
  HtWriteC(6,MidCol,LightCyan+BlueBG,'Write Procedures');
  HtWrite(8,8,Yellow+BlueBG,'HtWrite ');
  HtWriteEos(White+BlueBG,'   - will write a string to any location with any attributes');
  HtDelay(1000);
  HtWrite(13,33,Yellow+BlueBG,'Here''s 1000...');
  HtDelay(1000);
  FOR I := 1 TO 1000 DO
    HtWrite(10+Random(15),10+Random(60),Random($7F),'Testing');
  PressAnyKey(9);
  HtFill(10,2,15,76,White+BlueBG,' ');
  HtWrite(9,8,Yellow+BlueBG,'HtWriteC ');
  HtWriteEos(White+BlueBG,'  - will center a string about a column');
  HtDelay(1000);
  FOR I := 1 TO 7 DO
  HtWrite(10+I,40,SameAttr,'');
  HtWriteC(12,40,SameAttr,'1');
  HtWriteC(13,40,SameAttr,'22');
  HtWriteC(14,40,SameAttr,'333');
  HtWriteC(15,40,SameAttr,'This is a test');
  HtWriteC(16,40,SameAttr,'Centering a string about a column');
  PressAnyKey(18);
  HtFill(10,2,15,76,White+BlueBG,' ');
  HtWrite(10,8,Yellow+BlueBG,'HtWriteEos ');
  HtWriteEos(White+BlueBG,'- is similar to TP''s WRITE, but uses the internal variable');
  HtWrite(11,21,White+BlueBG,'EosOfs to keep track of an End-Of-String cursor which is');
  HtWrite(12,21,White+BlueBG,'updated with every HtWrite, HtWriteC, HtWriteEos');
  S := '"Here is a test string to show the HtWriteEos procedure"';
  HtDelay(2000);
  HtWrite(14,10,White+BlueBG,'Here''s an example :');
  HtWrite(15,10,White+BlueBG,'The string below will be written in different attributes');
  HtWrite(16,10,LightGray+BlueBG,S);
  HtDelay(1000);
  HtWrite(18,10,White+BlueBG,'Slowly first :');
  PressAnyKey(20);
  HtWrite(20,10,White+BlueBG,S[1]);
  FOR I := 2 TO Length(S) DO
  BEGIN
    HtWriteEos(Random($7F),S[I]);
    HtDelay(30);
  END;
  PressAnyKey(23);
  HtFill(18,10,7,60,White+BlueBG,' ');
  HtWrite(18,10,White+BlueBG,'Then quickly :');
  HtDelay(1000);
  HtWrite(20,10,White+BlueBG,S[1]);
  FOR I := 2 TO Length(S) DO
    HtWriteEos(Random($7F),S[I]);
  PressAnyKey(23);
  HtFill(18,10,7,60,White+BlueBG,' ');
  HtWrite(18,10,SameAttr,'By using the pre-defined attribute constant ');
  HtWriteEos(Yellow+BlueBG,'SameAttr ');
  HtWriteEos(SameAttr,'you can write');
  HtWrite(19,10,SameAttr,'strings without changing the attributes on the screen.');
  Box(22,15,1,3,Yellow+RedBG,NoBorder,' ');
  Box(22,20,1,3,White+GreenBG,NoBorder,' ');
  Box(22,25,1,3,LightCyan+BlueBG,NoBorder,' ');
  Box(22,30,1,3,LightBlue+BrownBG,NoBorder,' ');
  Box(22,35,1,3,LightCyan+MagentaBG,NoBorder,' ');
  Box(22,40,1,3,White+LightGrayBG,NoBorder,' ');
  Box(22,45,1,3,Red+BlueBG,NoBorder,' ');
  Box(22,50,1,3,LightGreen+GreenBG,NoBorder,' ');
  Box(22,55,1,3,Magenta+LightGrayBG,NoBorder,' ');
  HtDelay(2000);
  HtWrite(21,11,SameAttr,'This is a test of the attribute-constant SameAttr');
  HtWrite(22,12,SameAttr,'This is a test of the attribute-constant SameAttr');
  HtWrite(23,13,SameAttr,'This is a test of the attribute-constant SameAttr');
  PressAnyKey(CRTRows);
END;


PROCEDURE PageFour;
VAR I : BYTE;
BEGIN
  Box(2,2,23,78,White+BlueBG,SingleBorder,' ');
  HtWriteC(3,MidCol,White+BlueBG,'Screen Utilities');
  HtWriteC(4,MidCol,White+BlueBG,'for Turbo Pascal 5.5');
  HtWriteC(6,MidCol,LightCyan+BlueBG,'Cursor Control');
  HtWrite(8,8,Yellow+BlueBG,'GoToRC ');
  HtWriteEos(White+BlueBG,' - will move the cursor to any location on the screen');
  SetCursor(CursorUnderline);
  FOR I := 1 TO 50 DO
  BEGIN
    GoToRC(8+Random(8),20+Random(40));
    HtDelay(20);
  END;
  SetCursor(CursorOff);
  HtWrite(9,8,Yellow+BlueBG,'GoToEos ');
  HtWriteEos(White+BlueBG,'- will move the cursor to the End-Of-String marker');
  HtWrite(10,8,Yellow+BlueBG,'EosRow ');
  HtWriteEos(White+BlueBG,' - will return the current End-Of-String row');
  HtWrite(11,8,Yellow+BlueBG,'EosCol ');
  HtWriteEos(White+BlueBG,' - will return the current End-Of-String column');
  HtWrite(12,8,Yellow+BlueBG,'EosToRC ');
  HtWriteEos(White+BlueBG,'- will move the End-Of-String marker to any position');
  HtWrite(14,8,Yellow+BlueBG,'GetCursor ');
  HtWriteEos(White+BlueBG,'- will return the current cursor size');
  HtWrite(15,8,Yellow+BlueBG,'SetCursor ');
  HtWriteEos(White+BlueBG,'- will set the cursor size');
  PressAnyKey(17);
  HtWrite(17,8,White+BlueBG,'There are 4 pre-defined cursor-sizes :                       ');
  HtDelay(2000);
  HtWrite(18,10,Yellow+BlueBG,'CursorUnderline');
  GoToEos;
  SetCursor(CursorUnderline);
  HtDelay(1000);
  HtWrite(19,10,Yellow+BlueBG,'CursorHalfBlock');
  GoToEos;
  SetCursor(CursorHalfBlock);
  HtDelay(1000);
  HtWrite(20,10,Yellow+BlueBG,'CursorBlock');
  GoToEos;
  SetCursor(CursorBlock);
  HtDelay(1000);
  HtWrite(21,10,Yellow+BlueBG,'CursorOff');
  GoToEos;
  SetCursor(CursorOff);
  HtDelay(1000);
  HtWrite(23,8,White+BlueBG,'The initial cursor size is saved in the variable ');
  HtWriteEos(Yellow+BlueBG,'CursorInitial.');
  PressAnyKey(CRTRows);
END;


PROCEDURE PageFive;
VAR I,X,Y,DX,DY : INTEGER;
BEGIN
  Box(2,2,23,78,White+BlueBG,SingleBorder,' ');
  HtWriteC(3,MidCol,White+BlueBG,'Screen Utilities');
  HtWriteC(4,MidCol,White+BlueBG,'for Turbo Pascal 5.5');
  HtWriteC(6,MidCol,LightCyan+BlueBG,'Fill Procedures');
  HtWrite(8,8,Yellow+BlueBG,'HtFill ');
  HtWriteEos(White+BlueBG,'- will fill any rectangular area of the screen with the');
  HtWrite(9,17,White+BlueBG,'specified character and attributes');
  HtDelay(1000);
  HtWrite(13,33,Yellow+BlueBG,'Here''s 1000...');
  HtDelay(1000);
  FOR I := 1 TO 1000 DO
    HtFill(10+Random(5),10+Random(30),1+Random(10),Random(30),Random($7F),Chr(30+Random(30)));
  PressAnyKey(15);
  HtWrite(10,8,Yellow+BlueBG,'HtAttr ');
  HtWriteEos(White+BlueBG,'- will change the attributes on an area of the screen');
  FOR I := 1 TO 13 DO
    HtWrite(10+I,10,White+BlueBG,'012345678901234567890123456789012345678901234567890123456789');
  HtDelay(1000);
  X := 20; DX := 1;
  Y := 14; DY := 1;
  FOR I := 1 TO 100 DO
  BEGIN
    HtAttr(Y,X,6,31,Yellow+RedBG);
    HtDelay(50);
    HtAttr(Y,X,6,31,White+BlueBG);
    X := X+DX;
    Y := Y+DY;
    IF Y<12 THEN DY:=1;
    IF Y>17 THEN DY:=-1;
    IF X<11 THEN DX:=1;
    IF X>38 THEN DX:=-1;
  END;
  PressAnyKey(15);
END;


PROCEDURE PageSix;
BEGIN
  Box(2,2,23,78,White+BlueBG,SingleBorder,' ');
  HtWriteC(3,MidCol,White+BlueBG,'Screen Utilities');
  HtWriteC(4,MidCol,White+BlueBG,'for Turbo Pascal 5.5');
  HtWriteC(6,MidCol,LightCyan+BlueBG,'Read Functions');
  HtWrite(8,8,Yellow+BlueBG,'HtReadAttr ');
  HtWriteEos(White+BlueBG,'- will read the attributes on a specified location');
  HtWrite(9,8,Yellow+BlueBG,'HtReadChar ');
  HtWriteEos(White+BlueBG,'- will read the character on a specified location');
  PressAnyKey(15);
END;


PROCEDURE PageSeven;
VAR I,R1,R2,C1,C2 : BYTE;
BEGIN
  Box(2,2,23,78,White+BlueBG,SingleBorder,' ');
  HtWriteC(3,MidCol,White+BlueBG,'Screen Utilities');
  HtWriteC(4,MidCol,White+BlueBG,'for Turbo Pascal 5.5');
  HtWriteC(6,MidCol,LightCyan+BlueBG,'Box Procedures');
  HtWrite(8,8,Yellow+BlueBG,'Box       ');
  HtWriteEos(White+BlueBG,'- will draw a box of specified size');
  HtDelay(1000);
  HtWrite(13,33,Yellow+BlueBG,'Here''s 100...');
  HtDelay(1000);
  FOR I := 1 TO 100 DO
    Box(10+Random(5),10+Random(30),2+Random(9),5+Random(30),Random($7F),SingleBorder,' ');
  PressAnyKey(15);
  HtFill(9,8,16,70,White+BlueBG,' ');
  HtWrite(9,8,Yellow+BlueBG,'AddShadow ');
  HtWriteEos(White+BlueBG,'- will add a shadow to the box');
  HtDelay(1000);
  HtWrite(13,33,Yellow+BlueBG,'Here''s 100...');
  HtDelay(1000);
  FOR I := 1 TO 100 DO
  BEGIN
    R1 := 11+Random(5);
    R2 := 2+Random(7);
    C1 := 10+Random(30);
    C2 := 5+Random(30);
    Box(R1,C1,R2,C2,Random($7F),SingleBorder,' ');
    AddShadow(R1,C1,R2,C2);
  END;
  PressAnyKey(15);
  HtFill(10,8,15,70,White+BlueBG,' ');
  HtWrite(10,8,Yellow+BlueBG,'Explode   ');
  HtWriteEos(White+BlueBG,'- will explode a box of specified size');
  HtDelay(1000);
  HtWrite(13,33,Yellow+BlueBG,'Here''s 20...');
  HtDelay(1000);
  FOR I := 1 TO 20 DO
  BEGIN
    R1 := 12+Random(5);
    R2 := 2+Random(6);
    C1 := 10+Random(30);
    C2 := 5+Random(30);
    Explode(R1,C1,R2,C2,Random($7F),SingleBorder);
    AddShadow(R1,C1,R2,C2);
  END;
  PressAnyKey(15);
  HtFill(11,8,14,70,White+BlueBG,' ');
  HtWrite(11,8,White+BlueBG,'There are 5 pre-defined border-styles : ');
  HtWrite(14,8,LightCyan+BlueBG,'SingleBorder :');
  Box(14,25,1,5,White+CyanBG,SingleBorder,' ');
  HtWrite(18,8,LightCyan+BlueBG,'DoubleBorder :');
  Box(18,25,1,5,White+CyanBG,DoubleBorder,' ');
  HtWrite(14,38,LightCyan+BlueBG,'STopDSide :');
  Box(14,52,1,5,White+CyanBG,STopDSide,' ');
  HtWrite(18,38,LightCyan+BlueBG,'DTopSSide :');
  Box(18,52,1,5,White+CyanBG,DTopSSide,' ');
  HtWrite(22,8,LightCyan+BlueBG,'NoBorder     :');
  Box(22,25,1,5,White+CyanBG,NoBorder,' ');
  PressAnyKey(25);
END;


PROCEDURE PageEight;
VAR I : BYTE;
BEGIN
  Box(2,2,23,78,White+BlueBG,SingleBorder,' ');
  HtWriteC(3,MidCol,White+BlueBG,'Screen Utilities');
  HtWriteC(4,MidCol,White+BlueBG,'for Turbo Pascal 5.5');
  HtWriteC(6,MidCol,LightCyan+BlueBG,'Scroll Procedures');
  HtWrite(8,8,Yellow+BlueBG,'HtScrollUp   ');
  HtWriteEos(White+BlueBG,'- will scroll up the contents of a window');
  HtDelay(1000);
  Box(12,9,11,65,White+GreenBG,SingleBorder,' ');
  FOR I := 1 TO 255 DO
    HtWrite(12+Random(11),9+Random(65),White+GreenBG,Chr(30+Random(30)));
  AddShadow(12,9,11,65);
  HtDelay(1000);
  FOR I := 1 TO 11 DO
  BEGIN
    HtScrollUp(12,9,11,65,White+GreenBG);
    HtDelay(100);
  END;
  HtWrite(9,8,Yellow+BlueBG,'HtScrollDown ');
  HtWriteEos(White+BlueBG,'- will scroll down the contents of a window');
  HtDelay(1000);
  Box(12,9,11,65,White+GreenBG,SingleBorder,' ');
  FOR I := 1 TO 255 DO
    HtWrite(12+Random(11),9+Random(65),White+GreenBG,Chr(30+Random(30)));
  AddShadow(12,9,11,65);
  HtDelay(1000);
  FOR I := 1 TO 11 DO
  BEGIN
    HtScrollDown(12,9,11,65,White+GreenBG);
    HtDelay(100);
  END;
  PressAnyKey(18);
END;


PROCEDURE PageNine;
VAR Scr : ARRAY[1..6,1..30] OF WORD;
    I,R,C : BYTE;
BEGIN
  HtStoreToScr(1,1,CrtRows,CrtCols,Screen);
  Explode(4,5,5,50,White+BlueBG,SingleBorder);
  AddShadow(4,5,5,50);
  HtWrite(5,10,SameAttr,'Remember this page ? It was saved using');
  HtWrite(6,10,LightCyan+BlueBG,'HtStoreToMem ');
  HtWriteEos(SameAttr,'and re-displayed using');
  HtWrite(7,10,LightCyan+BlueBG,'HtStoreToScr.');
  PressAnyKey(25);
  Box(2,2,23,78,White+BlueBG,SingleBorder,'');
  HtWriteC(3,MidCol,White+BlueBG,'Screen Utilities');
  HtWriteC(4,MidCol,White+BlueBG,'for Turbo Pascal 5.5');
  HtWriteC(6,MidCol,LightCyan+BlueBG,'Screen save Procedures');
  HtStoreToMem(10,20,6,30,Scr);
  Box(11,21,3,26,White+RedBG,SingleBorder,' ');
  HtWrite(12,22,White+RedBG,'Here''s another example !');
  AddShadow(11,21,3,26);
  HtDelay(1000);
  HtStoreToScr(10,20,6,30,Scr);
  FOR I := 1 TO 20 DO
  BEGIN
    R := 6+Random(10);
    C := 10+Random(30);
    HtStoreToMem(R,C,6,30,Scr);
    Box(R+1,C+1,3,26,White+RedBG,SingleBorder,' ');
    AddShadow(R+1,C+1,3,26);
    HtWrite(R+2,C+2,White+RedBG,'Here''s another example !');
    HtDelay(200);
    HtStoreToScr(R,C,6,30,Scr);
  END;
END;


PROCEDURE PageTen;
VAR I : BYTE;
BEGIN
  HtFill(1,1,25,80,White+BlackBG,' ');
  SetFont(EGA43Font);
  SetCursor(CursorOff);
  Box(2,2,CRTRows-2,78,White+BlueBG,SingleBorder,' ');
  HtWriteC(3,MidCol,White+BlueBG,'Screen Utilities');
  HtWriteC(4,MidCol,White+BlueBG,'for Turbo Pascal 5.5');
  HtWriteC(6,MidCol,LightCyan+BlueBG,'Font Procedures');
  HtWrite(10,10,SameAttr,'There are two procedures to control the number of rows on the');
  HtWrite(11,10,SameAttr,'screen :');
  HtWrite(13,10,LightCyan+BlueBG,'SetFont ');
  HtWriteEos(SameAttr,'- will set the number of rows to 25 or 43/50');
  HtWrite(14,10,LightCyan+BlueBG,'GetFont ');
  HtWriteEos(SameAttr,'- will return the current number of rows to the variable');
  HtWrite(15,20,Yellow+BlueBG,'CRTRows');
  HtWrite(17,10,SameAttr,'There are two pre-defined constants to use in SetFont :');
  HtWrite(19,10,Yellow+BlueBG,'NormalFont ');
  HtWriteEos(SameAttr,'- will give 25 rows');
  HtWrite(20,10,Yellow+BlueBG,'EGA43Font  ');
  HtWriteEos(SameAttr,'- will give 43/50 rows');
  GetFont(CRTRows);
  PressAnyKey(CRTRows);
  SetFont(NormalFont);
END;


PROCEDURE PageEleven;
VAR I : BYTE;
BEGIN
  SetCursor(CursorOff);
  Box(2,2,23,78,White+BlueBG,SingleBorder,' ');
  HtWriteC(3,MidCol,White+BlueBG,'Screen Utilities');
  HtWriteC(4,MidCol,White+BlueBG,'for Turbo Pascal 5.5');
  HtWriteC(6,MidCol,LightCyan+BlueBG,'Pre-defined Constants');
  HtWritec(8,MidCol,SameAttr,'Attributes :');
   HtWrite(9,6,Yellow+BlueBG,'Black      = $00     DarkGray      = $08    BlackBG     = $00');
  HtWrite(10,6,Yellow+BlueBG,'Blue       = $01     LightBlue     = $09    BlueBG      = $10');
  HtWrite(11,6,Yellow+BlueBG,'Green      = $02     LightGreen    = $0A    GreenBG     = $20');
  HtWrite(12,6,Yellow+BlueBG,'Cyan       = $03     LightCyan     = $0B    CyanBG      = $30');
  HtWrite(13,6,Yellow+BlueBG,'Red        = $04     LightRed      = $0C    RedBG       = $40');
  HtWrite(14,6,Yellow+BlueBG,'Magenta    = $05     LightMagenta  = $0D    MagentaBG   = $50');
  HtWrite(15,6,Yellow+BlueBG,'Brown      = $06     Yellow        = $0E    BrownBG     = $60');
  HtWrite(16,6,Yellow+BlueBG,'LightGray  = $07     White         = $0F    LightGrayBG = $70');
  HtWrite(17,6,Yellow+BlueBG,'Blink      = $80     SameAttr      = -1');
  HtWritec(18,MidCol,SameAttr,'Border types :');
  HtWrite(19,6,Yellow+BlueBG,'NoBorder  = 0        SingleBorder = 1       DoubleBorder = 2');
  HtWrite(20,6,Yellow+BlueBG,'DTopSSide = 3        STopDSide    = 4');
  HtWritec(21,MidCol,SameAttr,'Text fonts :');
  HtWrite(22,6,Yellow+BlueBG,'NormalFont = 1       EGA43Font    = 2');
  PressAnyKey(CRTRows);
END;


PROCEDURE PageTwelve;
VAR I : BYTE;
BEGIN
  SetCursor(CursorOff);
  Box(2,2,23,78,White+BlueBG,SingleBorder,' ');
  HtWriteC(3,MidCol,White+BlueBG,'Screen Utilities');
  HtWriteC(4,MidCol,White+BlueBG,'for Turbo Pascal 5.5');
  HtWriteC(6,MidCol,LightCyan+BlueBG,'Procedures');
   HtWrite(7,6,Yellow+BlueBG,'GoToRC(Row,Col : BYTE);             EosToRC(Row,Col : BYTE);');
   HtWrite(8,6,Yellow+BlueBG,'GoToEos;                            HtInit;');
   HtWrite(9,6,Yellow+BlueBG,'SetCursor(Cursor : WORD);           GetCursor(VAR Cursor : WORD);');
  HtWrite(10,6,Yellow+BlueBG,'HtWrite(Row,Col:BYTE; Attr:INTEGER; S:STRING);');
  HtWrite(11,6,Yellow+BlueBG,'HtWriteEos(Attr:INTEGER; S:STRING);');
  HtWrite(12,6,Yellow+BlueBG,'HtAttr(Row,Col,Rows,Cols,Attr:BYTE);');
  HtWrite(13,6,Yellow+BlueBG,'HtFill(Row,Col,Rows,Cols,Attr:BYTE; C:CHAR);');
  HtWrite(14,6,Yellow+BlueBG,'HtScrollUp(Row,Col,Rows,Cols,BlankAttr:BYTE);');
  HtWrite(15,6,Yellow+BlueBG,'HtScrollDown(Row,Col,Rows,Cols,BlankAttr:BYTE);');
  HtWrite(16,6,Yellow+BlueBG,'HtStoreToMem(Row,Col,Rows,Cols:BYTE; Dest);');
  HtWrite(17,6,Yellow+BlueBG,'HtStoreToScr(Row,Col,Rows,Cols:BYTE; Source);');
  HtWrite(18,6,Yellow+BlueBG,'Box(Row,Col,Rows,Cols,Attr,Border:BYTE; Fill:CHAR);');
  HtWrite(19,6,Yellow+BlueBG,'Explode(Row,Col,Rows,Cols,Attr,Border:BYTE);');
  HtWrite(20,6,Yellow+BlueBG,'AddShadow(Row,Col,Rows,Cols:BYTE);');
  HtWrite(21,6,Yellow+BlueBG,'GetFont(VAR CRTRows : BYTE);');
  HtWrite(22,6,Yellow+BlueBG,'SetFont(Font : BYTE);');
  HtWrite(23,6,Yellow+BlueBG,'SetVideoMode(VideoMode : BYTE);');
  PressAnyKey(CRTRows);
END;


PROCEDURE PageThirteen;
VAR I : BYTE;
BEGIN
  SetCursor(CursorOff);
  Box(2,2,23,78,White+BlueBG,SingleBorder,' ');
  HtWriteC(3,MidCol,White+BlueBG,'Screen Utilities');
  HtWriteC(4,MidCol,White+BlueBG,'for Turbo Pascal 5.5');
  HtWriteC(6,MidCol,LightCyan+BlueBG,'Functions');
   HtWrite(7,6,Yellow+BlueBG,'EosCol : BYTE');
   HtWrite(8,6,Yellow+BlueBG,'EosRow : BYTE');
   HtWrite(9,6,Yellow+BlueBG,'HtReadAttr(Row,Col : BYTE) : BYTE;');
  HtWrite(10,6,Yellow+BlueBG,'HtReadChar(Row,Col : BYTE) : CHAR;');
  HtWrite(11,6,Yellow+BlueBG,'ShadowAttr(Attr : BYTE) : BYTE;');
  HtWrite(12,6,Yellow+BlueBG,'GetVideoMode : BYTE');
  HtWrite(13,6,Yellow+BlueBG,'HtDelay(MS : REAL);');
  HtWrite(14,6,Yellow+BlueBG,'HtReadKey(VAR Fk:BOOLEAN) : CHAR');
  Explode(17,10,4,60,Yellow+BlackBG,SingleBorder);
  AddShadow(17,10,4,60);
  HtWriteC(18,CRTCols DIV 2,White+BlackBG,'The Screen Utilities was written by Harald Thunem.');
  HtWriteC(19,CRTCols DIV 2,White+BlackBG,'No rights reserved !!');
  PressAnyKey(CRTRows);
END;


BEGIN
  Randomize;
  HtFill(1,1,25,80,White+BlackBG,' ');
  MidCol := CRTCols DIV 2;
  MidRow := CRTRows DIV 2;
  SetCursor(CursorOff);
  PageOne;
  PageTwo;
  PageThree;
  PageFour;
  PageFive;
  PageSix;
  PageSeven;
  PageEight;
  PageNine;
  PageTen;
  PageEleven;
  PageTwelve;
  PageThirteen;
  QuitProgram;
END.
