/* LocaleInformation_eo.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_eo extends ListResourceBundle
{
  private static final String[] shortMonths = {
    "jan",
    "feb",
    "mar",
    "apr",
    "maj",
    "jun",
    "jul",
    "a\u016dg",
    "sep",
    "okt",
    "nov",
    "dec",
    null,
  };

  private static final String[] months = {
    "januaro",
    "februaro",
    "marto",
    "aprilo",
    "majo",
    "junio",
    "julio",
    "a\u016dgusto",
    "septembro",
    "oktobro",
    "novembro",
    "decembro",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "di",
    "lu",
    "ma",
    "me",
    "\u0135a",
    "ve",
    "sa",
  };

  private static final String[] weekdays = {
    null,
    "diman\u0109o",
    "lundo",
    "mardo",
    "merkredo",
    "\u0135a\u016ddo",
    "vendredo",
    "sabato",
  };

  private static final String[] eras = {
    "aK",
    "pK",
  };

  private static final String[] ampms = {
    "atm",
    "ptm",
  };

  private static final String territoriesKeys = "TJ|TH|TG|GY|TD|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|OM|CA|BZ|BY|BW|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|AU|NA|AT|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MR|AG|MQ|AF|MP|AE|AD|MN|MM|ML|MK|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Ta\u011dikujo|Tajlando|Togolo|Gujano|\u0108ado|Gvineo-Bisa\u016do|Gvamo|Gvatemalo|Sud-Georgio kaj Sud-Sandvi\u0109insuloj|Grekujo|Ekvatora Gvineo|Gvadelupo|Svazilando|Sirio|Gvineo|Gambio|Gronlando|Salvadoro|Sao-Tomeo kaj Principeo|\u011cibraltaro|Ganao|Surinamo|Franca Gviano|Serbujo|Kartvelujo|Somalujo|Grenado|Senegalo|San-Marino|Unui\u011dinta Re\u011dlando|Siera-Leono|Gabono|Slovakujo|Svalbardo kaj Jan-Majen-insulo|Slovenujo|Sent-Heleno|Singapuro|Svedujo|Sudano|Sej\u015deloj|Salomonoj|Sa\u016dda Arabujo|Francujo|Ferooj|Mikronezio|Ruando|Rusujo|Fi\u011doj|Finnlando|Rumanujo|Reunio|Etiopujo|Hispanujo|Eritreo|Okcidenta Saharo|Egipto|Estonujo|Ekvadoro|Al\u011derio|Kataro|Domingo|Paragvajo|Dominiko|Bela\u016do|Danujo|\u011cibutio|Portugalujo|Puerto-Riko|Germanujo|Pitkarna Insulo|Sent-Piero kaj Mikelono|Pollando|Pakistano|Filipinoj|Papuo-Nov-Gvineo|Franca Polinezio|\u0108e\u0125ujo|Peruo|Kipro|Kabo-Verdo|Panamo|Kubo|Kostariko|Kolombio|\u0108inujo|Kameruno|\u0108ilio|Kukinsuloj|Ebur-Bordo|Svisujo|Kongolo|Centr-Afrika Respubliko|Omano|Kanado|Belizo|Belorusujo|Bocvano|Butano|Bahamoj|Brazilo|Nov-Zelando|Bolivio|Brunejo|Bermudoj|Niuo|Benino|Burundo|Barejno|Nauro|Bulgarujo|Burkino|Nepalo|Belgujo|Norvegujo|Banglade\u015do|Barbado|Zimbabvo|Nederlando|Bosnio-Hercegovino|Nikaragvo|Ni\u011derio|Norfolkinsulo|Azerbaj\u011dano|Ni\u011dero|Nov-Kaledonio|Arubo|Zambio|A\u016dstralio|Namibio|A\u016dstrujo|Argentino|Antarkto|Mozambiko|Angolo|Malajzio|Nederlandaj Antiloj|Meksiko|Armenujo|Malavio|Albanujo|Maldivoj|Sud-Afriko|Ma\u016dricio|Malto|Angvilo|Ma\u016dritanujo|Antigvo-Barbudo|Martiniko|Afganujo|Nord-Marianoj|Unui\u011dintaj Arabaj Emirlandos|Andoro|Mongolujo|Mjanmao|Malio|Makedonujo|Majoto|Mar\u015daloj|Madagaskaro|Moldavujo|Monako|Maroko|Jemeno|Libio|Latvujo|Luksemburgo|Litovujo|Lesoto|Liberio|Sri-Lanko|Li\u0125ten\u015dtejno|Sent-Lucio|Libano|Laoso|Kaza\u0125stano|Kejmanoj|Kuvajto|Sud-Koreo|Nord-Koreo|Sent-Kristofo kaj Neviso|Komoroj|Kiribato|Samoo|Kambo\u011do|Kirgizistano|Kenjo|Valiso kaj Futuno|Japanujo|Jordanio|Jamajko|Vanuatuo|Vjetnamo|Usonaj Virgulininsuloj|Britaj Virgulininsuloj|Venezuelo|Sent-Vincento kaj la Grenadinoj|Vatikano|Italujo|Islando|Irano|Irako|Uzbekujo|Brita Hindoceana Teritorio|Urugvajo|Hindujo|Israelo|Usono|Irlando|Indonezio|Usonaj malgrandaj insuloj|Ugando|Ukrajno|Hungarujo|Haitio|Kroatujo|Tanzanio|Honduro|Herda kaj Makdonaldaj Insuloj|Tajvano|Tuvalo|Trinidado kaj Tobago|Turkujo|Tongo|Tunizio|Turkmenujo";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "es|ku|eo|ks|en|el|qu|ko|kn|km|kl|kk|wo|ka|dz|jv|pt|ps|de|pl|da|vo|ja|vi|cy|pa|cs|iu|it|co|is|uz|or|ik|ur|om|ca|ie|id|uk|ia|oc|ug|hy|br|hu|bo|bn|hr|bi|tw|bh|bg|tt|no|be|ts|hi|tr|nl|zu|ba|to|he|tn|tl|tk|ha|ne|az|ti|ay|th|tg|na|te|zh|as|ar|ta|gu|my|am|za|mt|ms|gn|sw|mr|sv|gl|su|af|st|ss|mn|sr|sq|ml|ab|mk|aa|so|sn|mi|gd|sm|sl|mg|sk|ga|yo|si|sh|sg|yi|sd|fy|sa|fr|lv|lt|fo|rw|ru|lo|fj|ln|fi|ro|rn|rm|fa|la|xh|eu|ky|et";

  private static final String languagesValues = "hispana|kurda|esperanto|ka\u015dmira|angla|greka|ke\u0109ua|korea|kanara|kmera|gronlanda|kaza\u0125a|volofa|kartvela|dzonko|java|portugala|pa\u015dtua|germana|pola|dana|volapuko|japana|vjetnama|kimra|pan\u011daba|\u0109e\u0125a|inuita|itala|korsika|islanda|uzbeka|orijo|eskima|urduo|oroma|kataluna|okcidentalo|indonezia|ukraina|interlingvao|okcitana|ujgura|armena|bretona|hungara|tibeta|bengala|kroata|bislamo|akana|bihara|bulgara|tatara|norvega|belorusa|conga|hinda|turka|nederlanda|zulua|ba\u015dkira|tongaa|hebrea|cvana|filipina|turkmena|ha\u016dsa|nepala|azerbaj\u011dana|tigraja|ajmara|taja|ta\u011dika|naura|telugua|\u0109ina|asama|araba|tamila|gu\u011darata|birma|amhara|\u011duanga|malta|malaja|gvarania|svahila|marata|sveda|galega|sunda|afrikansa|sota|svazia|mongola|serba|albana|malajalama|ab\u0125aza|makedona|afara|somala|\u015dona|maoria|gaela|samoa|slovena|malagasa|slovaka|irlanda|joruba|sinhala|serbo-Kroata|sangoa|jida|sinda|frisa|sanskrito|franca|latva|litova|feroa|ruanda|rusa|la\u016da|fi\u011dia|lingala|finna|rumana|burunda|roman\u0109a|persa|latino|ksosa|e\u016dska|kirgiza|estona";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "\u00a0" },
    { "localPatternChars", "GjMtkHmslTDUSnahKzJdugAZ" },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "yy-MM-dd" },
    { "mediumDateFormat", "yyyy-MMM-dd" },
    { "longDateFormat", "yyyy-MMMM-dd" },
    { "fullDateFormat", "EEEE, d'-a de 'MMMM yyyy" },
    { "fullTimeFormat", "H'-a horo kaj 'm z" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
