/* Constants to identify all CAPA functions
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

/* =||>>================================================================<<||= */
/* 45678901234567890123456789012345678901234567890123456789012345678901234567 */
/* =||>>================================================================<<||= */

#ifndef   CAPA_FUNCTION_H
#define   CAPA_FUNCTION_H

#define  RANDOM_F       1
#define  CHOOSE_F       2
#define  TEX_F          3
#define  VAR_IN_TEX_F   4
#define  PIN_F          5
#define  CLASS_F        6
#define  SECTION_F      7
#define  PROBLEM_F      8
#define  SET_F          9
#define  NAME_F         10
#define  SNUMBER_F      11
#define  DUE_DATE_F     12
#define  DUE_DAY_F      13
#define  OPEN_DATE_F    14
#define  ANSWER_DATE_F  15
#define  TO_STRING_F    16
#define  FORMAT_F       17
#define  PICK_F         18
#define  HTML_F         19
#define  WEB_F          20
#define  LINK_F         21
#define  SUB_STRING_F   22
#define  GET_SEED_F     23
#define  SET_SEED_F     24
#define  ARRAY_INDEX_F  25
#define  ARRAY_SORTED_INDEX_F  26
#define  DURATION       27
#define  STRLEN_F       28
#define  STRCHR_F       29
#define  WEB_SERVER_F   30


/* ------------------------ Trigonometry Functions */

#define  SIN_F          31
#define  COS_F          32
#define  TAN_F          33
#define  ASIN_F         34
#define  ACOS_F         35
#define  ATAN_F         36
#define  SINH_F         37
#define  COSH_F         38
#define  TANH_F         39
#define  ASINH_F        40
#define  ACOSH_F        41
#define  ATANH_F        42
#define  J_ZERO_F       43
#define  J_ONE_F        44
#define  J_N_F          45
#define  Y_ZERO_F       46
#define  Y_ONE_F        47
#define  Y_N_F          48
#define  ATANTWO_F      49
#define  LOG_F          50
#define  LOG_TEN_F      51
#define  EXP_F          52
#define  POW_F          53
#define  ERF_F          54
#define  ERFC_F         55
#define  SQRT_F         56
#define  FACTORIAL_F    57

#define  ARRAY_MIN_F    58
#define  ARRAY_MAX_F    59


#define  MIN_F          60
#define  MAX_F          61
#define  ABS_F          62
#define  FLOOR_F        63
#define  CEIL_F         64
#define  SGN_F          65
#define  MOD_F          66
#define  REMAINDER_F    67
#define  SIGNIFICANT_F  68


#define  TO_INT_F           70
#define  ROUNDTO_F          71
#define  EVALUATE_F         72
#define  ARRAY_MOMENTS_F    73
#define  ARRAY_MEDIUM_F     74
#define  ARRAY_VARIANCE_F   76
#define  ARRAY_STD_DEV_F    77
#define  ARRAY_SKEWNESS_F   78
#define  ARRAY_INDEX_CNT_F  79

#define  CAPAID_PLUS    80
#define  SEAT_NUMBER    81
#define  IS_OPEN_F      82
#define  IS_DUE_F       83
#define  IS_ANSWER_F    84
#define  FIRSTNAME_F    85
#define  LASTNAME_F     86
#define  CLASSPATH_F    87
#define  CLASSNAME_F    88
#define  MANAGERMODE_F  89

#define  CORRECT_F      100
#define  TRIES_F        101
#define  GRADE_F        102

#define  RANDOM_NORMAL_F        103
#define  RANDOM_BETA_F          104
#define  RANDOM_GAMMA_F         105
#define  RANDOM_EXPONENTIAL_F   106
#define  RANDOM_POISSON_F       107
#define  RANDOM_CHI_F             108
#define  RANDOM_NONCENTRAL_CHI_F  109


#define  INIT_ARRAY_F                    110

#define  RANDOM_MULTIVARIATE_NORMAL_F    111

#define  MIS_ARG_COUNT  97
#define  MIS_ARG_TYPE   98
#define  UNKNOWN_F      99

/*************************************/

int     match_function( );
Symbol *do_function();

#endif  /* CAPA_FUNCTION_H */

