/*****************************************************************************
*   "Irit" - the 3d (not only polygonal) solid modeller.		     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
*   General, visible to others, definitions of Objects module.		     *
*****************************************************************************/

/*****************************************************************************
*   Prototype for visible function in the Objects module.		     *
*****************************************************************************/

#ifndef	OBJECTS_H
#define	OBJECTS_H

void SetUpPredefObjects(void);
void SetObjectAttrib(IPObjectStruct *PObj, char *Name, IPObjectStruct *Data);
void RemoveObjectAttrib(IPObjectStruct *PObj, char *Name);
void SetDumpLevel(int DumpLvl);
double ThisObjectIs(char *Name);
void IritObjectPrintfStdout(char *CtlStr, IPObjectStruct *PObjLst);
void IritObjectPrintf(FILE *File, char *CtlStr, IPObjectStruct *PObjLst);
double GetObjectSize(IPObjectStruct *ListObj);
double GetMeshSize(IPObjectStruct *ListObj, RealType *RDir);
IPObjectStruct *GetNilList(void);
IPObjectStruct *GetNthList(IPObjectStruct *ListObj, RealType *Rn);
IPObjectStruct *AppendLists(IPObjectStruct *ListObj1,
			    IPObjectStruct *ListObj2);
IPObjectStruct *ReverseListObj(IPObjectStruct *ListObj);
void SnocList(IPObjectStruct *PObj, IPObjectStruct *ListObj);
IPObjectStruct *GetObject(char *ObjName);
IPObjectStruct *GetObjectCoord(IPObjectStruct *PObj, RealType *RIndex);
void FreeObject(IPObjectStruct *PObj);
void DeleteObject(IPObjectStruct *PObj, int Free);
void InsertObject(IPObjectStruct *PObj);
void PrintObject(IPObjectStruct *PObj);
char *GetObjectTypeAsString(IPObjectStruct *PObj);
void PrintObjectList(IPObjectStruct *PObj);
IPObjectStruct *CoerceObjectTo(IPObjectStruct *PObj, RealType *RNewType);
void SaveObjectInFile(char *FileName, IPObjectStruct *PObj);
IPObjectStruct *LoadObjectFromFile(char *FileName);
int LoadSaveObjectParseError(char **ErrorMsg);
IPObjectStruct *GenMatObjectGeneric(IPObjectStruct *LstObjList);

IPObjectStruct *GenBOXObject(VectorType Pt,
			     RealType *WidthX,
			     RealType *WidthY, RealType *WidthZ);
IPObjectStruct *GenGBOXObject(VectorType Pt,
			      VectorType Dir1,
			      VectorType Dir2,
			      VectorType Dir3);
IPObjectStruct *GenCONEObject(VectorType Pt, VectorType Dir, RealType *R);
IPObjectStruct *GenCONE2Object(VectorType Pt,
			       VectorType Dir,
			       RealType *R1,
			       RealType *R2);
IPObjectStruct *GenCYLINObject(VectorType Pt, VectorType Dir, RealType *R);
IPObjectStruct *GenSPHEREObject(VectorType Center, RealType *R);
IPObjectStruct *GenTORUSObject(VectorType Center,
			       VectorType Normal,
			       RealType *Rmajor,
			       RealType *Rminor);
IPObjectStruct *GenPOLYDISKObject(VectorType N, VectorType T, RealType *R);
IPObjectStruct *GenPOLYGONObject(IPObjectStruct *PObjList,
				 RealType * RIsPolyline);
IPObjectStruct *GenObjectFromPolyList(IPObjectStruct *PObjList);
IPObjectStruct *GenCROSSECObject(IPObjectStruct *PObj);
IPObjectStruct *GenSURFREVObject(IPObjectStruct *Cross);
IPObjectStruct *GenEXTRUDEObject(IPObjectStruct *Cross, VectorType Dir);

#endif	/* OBJECTS_H */

