 /*
  * Khoros: $Id: xvoverlay.h,v 1.1 1991/05/10 04:12:31 khoros Exp $
  */

 /*
  * $Log: xvoverlay.h,v $
 * Revision 1.1  1991/05/10  04:12:31  khoros
 * Initial revision
 *
  */ 

/************************************************************
*
*  MODULE NAME:  Khoros "Overlay" object structure
*
*      PURPOSE:  To define the object structure for the
*		 overlay library.
*
*   WRITTEN BY: Stephanie Hallet & Mark Young
*
*************************************************************/


#ifndef	 _xvoverlay_h_
#define  _xvoverlay_h_


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xvinclude.h"	

#define	LINE		1
#define	CIRCLE		2
#define	RECTANGLE	3
#define TEXT		4
#define POLYGON		5
#define ELLIPSE		6
#define ARROW		7
#define IMAGE		8

#define MOUSE		1
#define KEYBOARD	2

/*
 *  structure for an overlay object
 *
 *  Most objects take only two points (rectangle - diagonal corners,
 *  circle - center and edge, line - end points).  Text takes
 *  only one point, and polygon has a varying number of points.
 */
typedef struct _xobject
{
 	int	type;		/* line, circle, rectangle, text, polygon */
	int	num;		/* number of points needed for object */
	XPoint	*points;	/* pointer to set of points */

	char    *color;		/* string as in "red" */
	XColor  *xcolor;		/* allocated color */

	int	line_width;	/* not used for text */
	int	isfilled;	/* not used for text */

	char	*text;		/* used for text only */
	char	*font;		/* used for text only */

	int	x;		/* upper-left corner of extent */
        int	y;		/* upper-left corner of extent */
        int	width;		/* width of extent */
        int	height;		/* height of extent */

	Pixmap  area;		/* saves the area under the object */
	Pixmap  image;		/* saves the area under the object */
	Region  region;		/* used for polygons & images only */

	struct _xobject *next;	/* points to next object */
	struct _xobject *last;	/* points to previous object */
} XObject;

XObject		*create_object(),
		*check_object(),
		*copy_object(),
		*insert_object(),
		*delete_object(),
		*edit_object(),
		*extent_object(),
		*find_object(),
		*lower_object(),
		*raise_object(),
		*resize_object(),
		*read_object(),
		*translate_object(),
		*read_overlays();

void		update_object(),
		update_overlays(),
		refresh_overlays(),
		output_overlays();
#endif /* _xvoverlay_h_ */
/* Don't add after this line */
