 /*
  * Khoros: $Id: initaflargs.c,v 1.1 1991/05/10 15:41:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: initaflargs.c,v 1.1 1991/05/10 15:41:06 khoros Exp $";
#endif

 /*
  * $Log: initaflargs.c,v $
 * Revision 1.1  1991/05/10  15:41:06  khoros
 * Initial revision
 *
  */ 

/******************************************************************

	Initialize Answer File Arguments (bring into main memory)

	source filename:			init_afile_args.c

	revision	  date			programmer
	--------	  ----			----------
	   0.0		Jan-05-85		don hush

******************************************************************

	usage
	-----

	init_afile_args(fd)

	int fd;

	description
	-----------

	  This routine brings all the arguments from the answer
	file into main memory and places them in a sorted linked
	list. It then creates a pointer array whose elements
	point to the successive members in the list so that
	a binary search routine can be used to find members of
	the array at a subsequent time.

******************************************************************/

#include "vgparm.h"

ARG_ENTRY first = { "","",NULL };
ARG_ENTRY **arg_table;
int num_args = 0;

init_afile_args(fd)

int fd;

{
    int err,i,j,len;
    char line[MAX_LINE_LEN],key[MAX_KEY_LEN];
    char temp_sarg[MAX_ARG_LEN],sarg[MAX_ARG_LEN];

    if (fd<0) return;

    if (fd!=0)
	lseek(fd,0L,0);

    while ( (err=get_arg_line(fd,line)) != 0 ) {

	if (err == -1) continue;

	temp_sarg[0] = '\0';
	sscanf(line," %s %[^#\n]",key,temp_sarg);

	len = strlen(temp_sarg);
	for (i=0,j=0;i<=len;i++) {
	    if (temp_sarg[i]=='\\') {
		if (temp_sarg[i+1]=='n')
		    sarg[j++] = '\n';
		i++;
	    }
	    else
		sarg[j++] = temp_sarg[i];
	}

	enter_arg(key,sarg);
    }

    make_table();
}

/******************************************************************

	Close Answer File and Free Memory

	source filename:			init_afile_args.c

	revision	  date			programmer
	--------	  ----			----------
	   0.0		Aug-18-90		John M. Salas

******************************************************************

	usage
	-----

	close_afile(fd)

	int fd;

	description
	-----------

	This routine will close the answer file and free the memory
	used in reading it in.

******************************************************************/

close_afile(fd)
int fd;

{
  ARG_ENTRY *pt1, *pt2;
  int i;

  close(fd);

  for ( pt1 = first.next , i=0 ; i < num_args ; i++ ) {

    pt2 = pt1->next;
    free(pt1);
    pt1 = pt2;

  }
  first.next = NULL;

  num_args = 0;
}
