 /*
  * Khoros: $Id: vdetilt.c,v 1.2 1991/10/02 00:03:55 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vdetilt.c,v 1.2 1991/10/02 00:03:55 khoros Exp $";
#endif

 /*
  * $Log: vdetilt.c,v $
 * Revision 1.2  1991/10/02  00:03:55  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vdetilt.c
 >>>>
 >>>>      Program Name: vdetilt
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Remove an illumination gradient from an image by subtracting
 >>>>	a best-fit plane.
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Thu Sep 26 13:16:25 1991
 >>>>
 >>>>          Routines: main- the main program for vdetilt
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vdetilt.h"


/****************************************************************
 *
 * Routine Name:  main program for vdetilt
 *
 *       Input:  
 *         -i  input image 
 *         -o  resulting detilted image 
 *
 *
 *         [-m] find tilt  operation masking image
 *         [-p] if yes, remove mean from image
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *img1, *img2, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
  exit(1);
}

READINPUT1(img1);
CHECKINPUT(program,img1);

if (vdetilt->m_flag) 
{
  READINPUT2(img2);
  MATCHINPUT(program,img1,img2);
}

/* -main_before_lib_call_end */

/* -main_library_call */
if(! lvdetilt(img1,img2,vdetilt->m_flag,vdetilt->p_logic) )
{
  (void) fprintf(stderr, "lvdetilt Failed\n");
  exit(1);
}
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vdetilt->o_file,img1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vdetilt 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vdetilt :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tRemove an illumination gradient from an image by subtracting\n");
	fprintf(stderr, "\ta best-fit plane.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting detilted image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-m]  find tilt  operation masking image (infile) [null]\n");
	fprintf(stderr,"\t[-p]  if yes, remove mean from image (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vdetilt\n");
	fprintf(stderr, "\t[-U] Gives the usage for vdetilt\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vdetilt.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vdetilt.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vdetilt
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting detilted image \n        {outfile}: "; 
char	*m_pstr = 
	"\nEnter: (m) find tilt  operation masking image \n        {infile}: "; 
char	*p_pstr = 
	"\nEnter: (p) if yes, remove mean from image \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vdetilt", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vdetilt.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vdetilt: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vdetilt.ans");
		}

	     }

	}

	/*
	 * allocate the vdetilt structure
	 */
	vdetilt = (vdetilt_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vdetilt_struct));

	/*
	 * get required arguments for vdetilt
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vdetilt->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vdetilt->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdetilt->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vdetilt->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vdetilt->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vdetilt->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vdetilt->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdetilt->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vdetilt->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vdetilt->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vdetilt
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vdetilt->m_flag = vget_infile(fid, prompt_flag,
	"-m", m_pstr, &(vdetilt->m_file))
;

	vdetilt->p_flag = vget_logic(fid, prompt_flag,
	"-p", p_pstr, &(vdetilt->p_logic), 1);


}



