 /*
  * Khoros: $Id: lvbandspt1.c,v 1.2 1991/10/02 00:22:42 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvbandspt1.c,v 1.2 1991/10/02 00:22:42 khoros Exp $";
#endif

 /*
  * $Log: lvbandspt1.c,v $
 * Revision 1.2  1991/10/02  00:22:42  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvbandspt1.c
 >>>>
 >>>>      Program Name: vbandspt1
 >>>>
 >>>> Date Last Updated: Wed Aug 21 15:24:58 1991 
 >>>>
 >>>>          Routines: lvbandspt1 - the library call for vbandspt1
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvbandspt1 - library call for vbandspt1
*
* Purpose:
*    
*    Extracts all bands from an image and creates separate images
*    from each band.
*    
*    

* Input:
*    
*    img            the input xvimage structure to extract bands from.
*    
*    images         a list of pointers  to  xvimage  structures.   The
*                   result    is    passed   in   from   a   call   to
*                   creat_images_list(image->num_data_bands).
*    
*    img_file_name  a pointer to the name of the img file.
*    
*    mod_comment    this is a flag that if set to  true  modifies  the
*                   new  image's  comment  field by appending the data
*                   band number and the original file name from  which
*                   the new image was created.
*    
*    

* Output:
*    
*    images         returns a list of pointers to xvimage  structures,
*                   the  new  images containing only one data band are
*                   returned in this structure.
*    
*    

*
* Written By: Tom Sauer
*    
*    1/18/91   Added an error message trapping for input  images  with
*              only one band. C.Gage
*    
*    8/18/91   Added a line of code to fix bug reported by Bengt  Mar-
*              tensson.  Location data not being copied.
*    
*    

****************************************************************/


/* -library_def */
int
lvbandsprt(img, images, img_file_name, mod_comment)
struct xvimage *images[], *img;
char *img_file_name;
int mod_comment;
/* -library_def_end */

/* -library_code */
{
        int     data_size,dcount,map_size,mcount,lsize,lcount;
        int     i;
        char    *program = "lvbandsprt";
        char    comment[MAXNAMLEN], *file;
        char    *vbasename();

             /* check to see if only one images exists in the input file */

        if ( ! (proper_num_images(program,img,1,FALSE))) {
           (void) fprintf(stderr,
                  "%s: ERROR All inputs must contain only one image\n"
                  , program);
           return(0);
       }


         /* go compute the image size and map size in bytes */

        if (! (imagesize(img,&data_size,&dcount,&map_size,
                             &mcount,&lsize,&lcount)))
        {
            (void) fprintf(stderr,
                    "%s: ERROR imagesize failed\n", program);
            return(0);
        }

         /* want the data_size for each band, not the total image data size */
         /* so divide by the number of image bands                          */

        data_size /= img->num_data_bands;

         /* if the map scheme is ONEPERBAND then only want the size of each */
         /* map, not the total map size                                     */

        if ( img->map_scheme == VFF_MS_ONEPERBAND) 
               map_size /= img->num_data_bands;

           /* loop through all data bands and separate them out into
              one band images, process the maps and copy the image
              header from the input image  */

        for (i = 0; i < img->num_data_bands; i++) {
           images[i]->imagedata = &img->imagedata[data_size*i];
           switch (img->map_scheme) {
                case VFF_MS_NONE:
                  break;
                case VFF_MS_ONEPERBAND:
                  images[i]->maps = &img->maps[map_size*i];
                  break;
                case VFF_MS_SHARED:
                  images[i]->maps = &img->maps[0];
                  break;
                default:
                  (void) fprintf(stderr,
                     "%s: ERROR Invalid map scheme. Map scheme should be either\n",
                     program);
                  (void) fprintf(stderr,
                     "               NONE, ONEPERBAND or SHARED\n");
                  return(0);
                  break;
              }
              copyheader(img, images[i]);
              images[i]->num_data_bands = 1;
              images[i]->color_space_model = VFF_CM_NONE;
              images[i]->location = img->location;  /* bug fix for location
                                                       data */

                /* if the modify comment flag is set then get the
                   input image filename, append to the new image
                   the band number and the image name the band was
                   extracted from  */

              if ( mod_comment ) {
                 file = vbasename(img_file_name);
                 (void) sprintf(comment, "Data Band %d from image:  %s.\n\n",
                    i, file);
                 create_comment(images[i]->comment, comment, img->comment);
              }
        }
        return(1);
}
/* -library_code_end */
