 /*
  * Khoros: $Id: vgconst.c,v 1.2 1991/12/18 09:37:13 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vgconst.c,v 1.2 1991/12/18 09:37:13 dkhoros Exp $";
#endif

 /*
  * $Log: vgconst.c,v $
 * Revision 1.2  1991/12/18  09:37:13  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgconst.c
 >>>>
 >>>>      Program Name: vgconst
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Creates an image with constant pixel values.
 >>>>	
 >>>>	

 >>>>            Author: Marcelo Teran, Ramiro Jordan, Tom Sauer
 >>>>
 >>>> Date Last Updated: Mon Dec  9 23:23:00 1991
 >>>>
 >>>>          Routines: main- the main program for vgconst
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vgconst.h"


/****************************************************************
 *
 * Routine Name:  main program for vgconst
 *
 *       Input:  
 *         -o  resulting image 
 *
 *
 *         [-trigger] trigger input
 *         [-r] Number of rows  (value > 0)
 *         [-c] Number of columns  (value > 0)
 *         [-b] Number of data bands  (value > 0)
 *         [-l] image constant level 
 *         [-m] image imaginary constant level 
 *         [-t] lets user choose data type of image
 *		'bit' (choose bit data type),
 *		'byte' (choose byte data type),
 *		'short' (choose short data type),
 *		'int' (choose integer data type),
 *		'float' (choose float data type),
 *		'double' (choose double data type),
 *		'complex' (choose complex data type),
 *		 or 'dcomplex' (choose dcomplex data type)
 *		   [default = float] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image;
    int type;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if (check_args()) exit(1);

  if(!vget_type(&type,vgconst->t_toggle)){
     fprintf(stderr,"%s:  Invalid data type specified\n",program);
     exit(1);
  }
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvgconst( &image, vgconst->r_int, vgconst->c_int, type,
                         vgconst->l_float, vgconst->m_float, vgconst->b_int))
    {
        (void) fprintf(stderr, "lvgconst Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vgconst->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vgconst 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vgconst :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreates an image with constant pixel values.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
(void) fprintf(stderr,"where \"t\" :\n");
(void) fprintf(stderr,"\t[ byte    ]\n");
(void) fprintf(stderr,"\t[ short   ]\n");
(void) fprintf(stderr,"\t[ int     ]\n");
(void) fprintf(stderr,"\t[ float   ]\n");
(void) fprintf(stderr,"\t[ double   ]\n");
(void) fprintf(stderr,"\t[ complex ]\n");
(void) fprintf(stderr,"\t[ dcomplex ]\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-o  resulting image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr,"\t[-r]  Number of rows (integer, > 0) [512]\n");
	fprintf(stderr,"\t[-c]  Number of columns (integer, > 0) [512]\n");
	fprintf(stderr,"\t[-b]  Number of data bands (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-l]  image constant level (float) [0]\n");
	fprintf(stderr,"\t[-m]  image imaginary constant level (float) [0]\n");
	fprintf(stderr, "\t[-t]  lets user choose data type of image\n");
	fprintf(stderr, "\t\t'bit'  (choose bit data type),\n");
	fprintf(stderr, "\t\t'byte'  (choose byte data type),\n");
	fprintf(stderr, "\t\t'short'  (choose short data type),\n");
	fprintf(stderr, "\t\t'int'  (choose integer data type),\n");
	fprintf(stderr, "\t\t'float'  (choose float data type),\n");
	fprintf(stderr, "\t\t'double'  (choose double data type),\n");
	fprintf(stderr, "\t\t'complex'  (choose complex data type),\n");
	fprintf(stderr, "\t\t or 'dcomplex'  (choose dcomplex data type)\n");
	fprintf(stderr, "\t\t[default = float]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vgconst\n");
	fprintf(stderr, "\t[-U] Gives the usage for vgconst\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vgconst.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vgconst.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vgconst
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) resulting image \n        {outfile}: "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*r_pstr = 
	"\nEnter: (r) Number of rows \n        {integer, > 0 [512] }: "; 
char	*c_pstr = 
	"\nEnter: (c) Number of columns \n        {integer, > 0 [512] }: "; 
char	*b_pstr = 
	"\nEnter: (b) Number of data bands \n        {integer, > 0 [1] }: "; 
char	*l_pstr = 
	"\nEnter: (l) image constant level \n        {float [0.000000] }: "; 
char	*m_pstr = 
	"\nEnter: (m) image imaginary constant level \n        {float [0.000000] }: "; 
char	*t_pstr = "\nEnter: (t) lets user choose data type of image -- \n      \t\t'bit' (choose bit data type)\n\t\t'byte' (choose byte data type)\n\t\t'short' (choose short data type)\n\t\t'int' (choose integer data type)\n\t\t'float' (choose float data type)\n\t\t'double' (choose double data type)\n\t\t'complex' (choose complex data type)\n\t\tor 'dcomplex' (choose dcomplex data type)\n  [float]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vgconst", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vgconst.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vgconst: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vgconst.ans");
		}

	     }

	}

	/*
	 * allocate the vgconst structure
	 */
	vgconst = (vgconst_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vgconst_struct));

	/*
	 * get required arguments for vgconst
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vgconst->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vgconst->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgconst->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vgconst->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vgconst->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vgconst
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vgconst->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(vgconst->trigger_file))
;

	vgconst->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(vgconst->r_int),
	512, 2, 2);

	vgconst->c_flag = vget_int(fid, prompt_flag,
	"-c", c_pstr, &(vgconst->c_int),
	512, 2, 2);

	vgconst->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(vgconst->b_int),
	1, 2, 2);

	vgconst->l_flag = vget_float(fid, prompt_flag,
	"-l", l_pstr, &(vgconst->l_float),
	0.000000, 0.000000, 0.000000);

	vgconst->m_flag = vget_float(fid, prompt_flag,
	"-m", m_pstr, &(vgconst->m_float),
	0.000000, 0.000000, 0.000000);


	/*
	 * get optional toggles for vgconst
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vgconst->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vgconst->t_toggle),
		"float");

		if (((strcmp(vgconst->t_toggle, "bit") == 0)) || 
		     ((strcmp(vgconst->t_toggle, "byte") == 0)) || 
		     ((strcmp(vgconst->t_toggle, "short") == 0)) || 
		     ((strcmp(vgconst->t_toggle, "int") == 0)) || 
		     ((strcmp(vgconst->t_toggle, "float") == 0)) || 
		     ((strcmp(vgconst->t_toggle, "double") == 0)) || 
		     ((strcmp(vgconst->t_toggle, "complex") == 0)) || 
		     ((strcmp(vgconst->t_toggle, "dcomplex") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vgconst->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vgconst->t_toggle),
		"float");

		if (((strcmp(vgconst->t_toggle, "bit") != 0)) && 
		     ((strcmp(vgconst->t_toggle, "byte") != 0)) && 
		     ((strcmp(vgconst->t_toggle, "short") != 0)) && 
		     ((strcmp(vgconst->t_toggle, "int") != 0)) && 
		     ((strcmp(vgconst->t_toggle, "float") != 0)) && 
		     ((strcmp(vgconst->t_toggle, "double") != 0)) && 
		     ((strcmp(vgconst->t_toggle, "complex") != 0)) && 
		     ((strcmp(vgconst->t_toggle, "dcomplex") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



