 /*
  * Khoros: $Id: vgfractal.c,v 1.2 1991/12/18 09:40:45 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vgfractal.c,v 1.2 1991/12/18 09:40:45 dkhoros Exp $";
#endif

 /*
  * $Log: vgfractal.c,v $
 * Revision 1.2  1991/12/18  09:40:45  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgfractal.c
 >>>>
 >>>>      Program Name: vgfractal
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Creates a fractal image with a desired fractal dimension.
 >>>>	
 >>>>	

 >>>>            Author: Charlie Gage
 >>>>
 >>>> Date Last Updated: Mon Dec  9 23:26:42 1991
 >>>>
 >>>>          Routines: main- the main program for vgfractal
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vgfractal.h"


/****************************************************************
 *
 * Routine Name:  main program for vgfractal
 *
 *       Input:  
 *           -o  Output image filename 
 *
 *
 *           [-trigger] trigger input
 *           [-r] Number of recursions  (2 < value < 10)
 *           [-h] Hurst coefficient  (0.000 < value < 1.000)
 *           [-d] Standard deviation  (value > 0.0)
 *           [-s] Seed  (value >= 0)
 *           [-c] Coastlines
 *           [-m] Random additions
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *createimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);
/* -main_before_lib_call_end */

/* -main_library_call */
/* Call the lib routine for generation of fractal image */

if(! lvgfractal(&image, vgfractal->r_int, vgfractal->h_float, vgfractal->d_float, vgfractal->s_int, vgfractal->c_logic, vgfractal->m_logic))
 {
   (void) fprintf(stderr, "lvgfractal Failed\\n");
   exit(1);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vgfractal->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vgfractal 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vgfractal :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreates a fractal image with a desired fractal dimension.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-o  Output image filename  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr,"\t[-r]  Number of recursions (integer, 2 to 10) [6]\n");
	fprintf(stderr,"\t[-h]  Hurst coefficient (float,  0.000 to 1.000) [0.5]\n");
	fprintf(stderr,"\t[-d]  Standard deviation (float, > 0.0) [1]\n");
	fprintf(stderr,"\t[-s]  Seed (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-c]  Coastlines (boolean) [false]\n");
	fprintf(stderr,"\t[-m]  Random additions (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vgfractal\n");
	fprintf(stderr, "\t[-U] Gives the usage for vgfractal\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vgfractal.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vgfractal.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vgfractal
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) Output image filename \n        {outfile}: "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*r_pstr = 
	"\nEnter: (r) Number of recursions \n        {integer, 2 to 10 [6] }: "; 
char	*h_pstr = 
	"\nEnter: (h) Hurst coefficient \n        {float,  0.000 to 1.000 [0.500000] }: "; 
char	*d_pstr = 
	"\nEnter: (d) Standard deviation \n        {float, > 0.0 [1.000000] }: "; 
char	*s_pstr = 
	"\nEnter: (s) Seed \n        {integer, >= 0 [0] }: "; 
char	*c_pstr = 
	"\nEnter: (c) Coastlines \n        {boolean, (y/n)  [no] }: "; 
char	*m_pstr = 
	"\nEnter: (m) Random additions \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vgfractal", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vgfractal.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vgfractal: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vgfractal.ans");
		}

	     }

	}

	/*
	 * allocate the vgfractal structure
	 */
	vgfractal = (vgfractal_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vgfractal_struct));

	/*
	 * get required arguments for vgfractal
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vgfractal->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vgfractal->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgfractal->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vgfractal->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vgfractal->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vgfractal
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vgfractal->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(vgfractal->trigger_file))
;

	vgfractal->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(vgfractal->r_int),
	6, 2, 10);

	vgfractal->h_flag = vget_float(fid, prompt_flag,
	"-h", h_pstr, &(vgfractal->h_float),
	0.500000, 0.000000, 1.000000);

	vgfractal->d_flag = vget_float(fid, prompt_flag,
	"-d", d_pstr, &(vgfractal->d_float),
	1.000000, 2.000000, 2.000000);

	vgfractal->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(vgfractal->s_int),
	0, 1, 1);

	vgfractal->c_flag = vget_logic(fid, prompt_flag,
	"-c", c_pstr, &(vgfractal->c_logic), 0);

	vgfractal->m_flag = vget_logic(fid, prompt_flag,
	"-m", m_pstr, &(vgfractal->m_logic), 0);


}



