 /*
  * Khoros: $Id: forms.h,v 1.3 1991/12/18 09:13:08 dkhoros Exp $
  */

 /*
  * $Log: forms.h,v $
 * Revision 1.3  1991/12/18  09:13:08  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
 
#ifndef _forms_h_
#define _forms_h_

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>	     file: forms.h					 <<<<
   >>>>                                                          <<<<
   >>>>      contains: * xvf_form, xvf_guide_button, xvf_pane 	 <<<<
   >>>>                  and xvf_selection structures            <<<<       
   >>>>		       * various structures for use by xvforms   <<<<
   >>>>	               * declaration of internally used          <<<<
   >>>>			 xvforms  functions                      <<<<
   >>>>		       * #defines used by the xvforms library    <<<<
   >>>>                                                          <<<<
   >>>>      written by: Danielle Argiro & Stephanie Hallett     <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "xvforms.h"
#include "form_list.h"


/*
 *  The Callback_Data structure contains all the
 *  information needed for a callback routine -
 *  all callback routines will need the line_info information,
 *  as well as the data base and the index into the database
 *  which specifies the appropriate line
 */
  
typedef struct {
	xvf_form         *formptr;
	xvf_sub_form     *subformptr;
	xvf_guide_button *guideptr;
        xvf_selection    *selptr;
	int	          doing_toggle;
        xvf_selection    *toggle_start;
	} Callback_Data;
	

/*
 *  The IntScroll_Data structure contains all the
 *  information needed for a callback routine for an int scroll bar
 */

typedef struct {
	xvf_form         *formptr;
	xvf_sub_form     *subformptr;
	xvf_guide_button *guideptr;
	xvf_selection    *selptr;
        int  		  int_min;
        int  		  int_max;
        int  		  int_value;
        int  		  max_int_length;
        int  		  interval;
        int  		  bar_width;
        int  		  increment;
        Widget 		  int_val_widget;
        Widget 		  int_scroll;
        }  IntScroll_Data;

/*
 *  The IntScroll_Data structure contains all the
 *  information needed for a callback routine for an int scroll bar
 */

typedef struct {
	xvf_form         *formptr;
	xvf_sub_form     *subformptr;
	xvf_guide_button *guideptr;
	xvf_selection    *selptr;
        float  		  float_min;
        float  		  float_max;
        float  		  float_value;
        int   		  max_float_length;
        float             interval;
        int               bar_width;
        float             increment;
        Widget            float_val_widget;
        Widget            float_scroll;
        }  FloatScroll_Data;

/*
 * this structure is for looking up desired info about an int asciiString 
 * widget with a scroll bar from within its XtActionProc
 */
typedef struct int_scroll_link {
		Widget  int_value;
		IntScroll_Data *scroll_info;
		struct int_scroll_link *next;
		} xvf_int_scroll_link;

xvf_int_scroll_link *int_scroll_list;


/*
 * this structure is for looking up desired info about a float asciiString 
 * widget with a scroll bar from within its XtActionProc
 */
typedef struct float_scroll_link {
                Widget  float_value;
                FloatScroll_Data *scroll_info;
                struct float_scroll_link *next;
                } xvf_float_scroll_link;

xvf_float_scroll_link *float_scroll_list;


/*
 * this structure is for looking up desired info about a ("live") int or float
 * selection that does *not* have a scroll bar.  It is also used for "live"
 * string, inputfile or outputfile selections, so that the asciiString widget 
 * used in the selection may be paired with its Callback Data (a convenient,
 * already-defined structure which contains everything we would need) from 
 * within its  XtActionProc: xvf_return_live_int, xvf_return_live_float,
 * xvf_return_live_string, xvf_return_live_infile, and xvf_return_live_outfile()
 */
typedef struct  live_sel_link {
                Widget  value_widget;
                Callback_Data *live_data;
                struct live_sel_link *next;
                } xvf_live_sel_link;

xvf_live_sel_link *live_sel_list;


/*
 *  the Internal Database struct 
 */

typedef struct _db {            /* a database can be stored in this */
   char *db[512];               /* structure.                       */
} DataBase;




/**************************************************************o*
*
*	The following are declarations for all xvform 
*	functions, so that they do not have to be declared
*	in each routine that uses them
*
*
*
**************************************************************/


/*
 *  Create_Form routine that puts up the backplane of
 *  the entire form. Takes arguments
 *			char *database[];
 *			char **argv;
 *			int  argc;
 */

char *calloc();
	
/*
 *	xvf_form *xvf_create_form();  (Declared in xvforms.h)
 */
	int xvf_fill_in_master();
	int xvf_fill_in_guide();
	int xvf_fill_in_pane();
	int xvf_fill_in_toggle();

/*
 *
 *   run_form  runs the forms
 *
 */

/*
 *	int   run_form_wait();		(Declared in xvforms.h)
 */
	int   map_form_list();	    /* maps whole list and updates forms */
	void  map_whole_form();      /* maps master & sub forms */
	void  map_subform();   	    /* maps one sub form */
	void  map_master_form();    /* maps master only */
	void  map_this_form();      /* low level mapping */
	void  map_this_subform();   /* low level mapping */
	int   unmap_form_list();    /* unmaps whole list and updates forms */
	void  unmap_whole_form();      /* unmaps master & sub forms */
	void  unmap_subform();        /* unmaps one sub form */
	void  unmap_master_form();    /* unmaps master only */
	void  unmap_this_form();      /* low level unmapping */
	void  unmap_this_subform();   /* low level unmapping */

	void map_this_form_glyph();
	void map_this_subform_glyph();
	void  unmap_this_form_glyph();
	void  unmap_this_subform_glyph();


	Widget xvf_create_backplane();
	Widget xvf_create_subform_sel();
	Widget xvf_create_psuedosubform_sel();
	Widget xvf_create_master_action_sel();
	Widget xvf_create_master_submenu();
	Widget xvf_create_guide_sel();
	Widget xvf_create_quit_master_sel();
	Widget xvf_create_quit_subform_sel();
	Widget xvf_create_quit_pane_sel();
	Widget xvf_create_workspace_sel();
	Widget xvf_create_subform_action_sel();
	Widget xvf_create_help_sel();
	Widget xvf_create_input_sel();
	Widget xvf_create_output_sel();
	Widget xvf_create_int_sel();
	Widget xvf_create_float_sel();
	Widget xvf_create_logic_sel();
	Widget xvf_create_string_sel();
	Widget xvf_create_cycle_sel();
	Widget xvf_create_list_sel();
	Widget xvf_create_toggle_sel();
	Widget xvf_create_text_sel();
	Widget xvf_create_routine_sel();
	Widget xvf_create_boolean_widget();
	Widget xvf_create_form_backplane();
	Widget xvf_create_blank_sel();
	Widget xvf_create_ansinfile_sel();
	Widget xvf_create_ansoutfile_sel();
	Widget xvf_create_pane_action_sel();

/*  Routine to clean up the widgets that don't have
 *  callbacks.
 */
	void xvf_collect_check_data();
	
/*
 *  Get_Line routine returns a #define'd integer that
 *  indicates what type of line we have
 *	Takes:  char *line;
 */
	int xvf_get_line_type();

/*
 *  Parsing routines parse a particular type of line
 *  {called according to the #define'd int returned by 
 *  xvf_get_line_type() above} and fill in the line_info
 *  structure accordingly.  They return true (0) on a successful 
 *  line parse and false (0) if they are not successful.
 *	Each parsing routine takes arguments:
 *			char      *line;
 *			Line_Info *line_info;
 */

 	int xvf_parse_startform_line();
 	int xvf_parse_startmaster_line();
 	int xvf_parse_startsubform_line();
	int xvf_parse_startguide_line();
	int xvf_parse_startpane_line();
	int xvf_parse_subformbutton_line();
	int xvf_parse_psuedosubform_line();
	int xvf_parse_master_action_line();
	int xvf_parse_guide_line();
	int xvf_parse_quit_line();
	int xvf_parse_subform_action_line();
	int xvf_parse_help_line();
	int xvf_parse_input_line();
	int xvf_parse_output_line();
	int xvf_parse_int_line();
	int xvf_parse_float_line();
	int xvf_parse_logic_line();
	int xvf_parse_string_line();
	int xvf_parse_routine_line();
	int xvf_parse_toggle_line();
	int xvf_parse_blank_line();
	int xvf_parse_pane_action_line();
	int xvf_parse_text_line();
	int xvf_parse_includepane_line();
	int xvf_parse_includesubform_line();
	int xvf_parse_libcall_line();
	int xvf_parse_ansinfile_line();
	int xvf_parse_ansoutfile_line();

/*
 *  Declarations of Callbacks 
 */

	void xvf_quit_master_cb();
	void xvf_quit_subform_cb();
	void xvf_quit_pane_cb();

        void xvf_subform_cb();
        void xvf_psuedo_subform_cb();
        void xvf_guide_cb();
        void xvf_master_action_cb();
        void xvf_logic_opt_cb();
        void xvf_logic_val_cb();
        void xvf_cycle_opt_cb();
        void xvf_cycle_val_cb();
        void xvf_list_opt_cb();
        void xvf_list_val_cb();

        void xvf_int_opt_cb();
        void xvf_int_incr_scroll_cb();
        void xvf_int_flow_scroll_cb();

	void xvf_float_opt_cb();
        void xvf_float_incr_scroll_cb();
        void xvf_float_flow_scroll_cb();

	void xvf_string_opt_cb();
	void xvf_input_label_cb();
	void xvf_ansinfile_label_cb();
	void xvf_ansoutfile_label_cb();
	void xvf_input_opt_cb();
	void xvf_output_label_cb();
	void xvf_output_opt_cb();
	void xvf_toggle_opt_cb();
	void xvf_subform_action_cb();
	void xvf_pane_action_cb();

	void xvf_master_help_button_cb();
	void xvf_subform_help_button_cb();
	void xvf_pane_help_button_cb();

	void xvf_routine_cb();
	void xvf_glyph_cb();
	void xvf_unglyph_cb();

/*
 *  Action Procedures for "live" selections' asciiString widgets
 */
	void xvf_update_int_scroll();
	void xvf_update_float_scroll();
	void xvf_update_forms_from_answerfile();
	void xvf_update_answerfile_from_forms();
	void xvf_return_live_int();
	void xvf_return_live_float();
	void xvf_return_live_string();
	void xvf_return_live_infile();
	void xvf_return_live_outfile();

/* 
 *  Two routines to help with toggleing
 */
	void xvf_change_opt_selected();
	void xvf_do_toggle();

/*
 * Utilities
 */

	int  xvf_get_line_type();
        char *xvf_strip_dash();
        char *xvf_strip_path();
        char *xvf_prepend_env_dir();
        void xvf_update_app_changes();

	char *xvf_create_readerror_mesg();
        char *xvf_create_mesg();
        char **xvf_realloc_database();

	float   xvf_get_scroll_incr();

	Callback_Data *xvf_init_cb_data();
	IntScroll_Data *xvf_init_int_scroll_data();
	FloatScroll_Data *xvf_init_float_scroll_data();

	/* kludge to get jp w/ cantata working */
	int  client_cantata;


/*
 *  Various & Sundry declarations
 */
xvf_sub_form *current_subform;
xvf_form     *current_form;
Cursor	      xvf_cursor;
int	      jp_playing, jp_recording;

Colormap  xvf_colormap;
Visual	  *xvf_visual;
int	  xvf_x, xvf_y;


/*
 *  Routines to allow Application Program to change Forms
 *
 *	(Declared in xvforms.h) 
 *
 *	int xvf_change_selection();
 *	int xvf_change_input();
 */

/*
 *  Routines to help Application Program to use Forms
 *
 *	(Declared in xvforms.h)	
 *
 *	Display *xvf_initialize();
 */


        XFontStruct *xvf_get_font();
#endif
/* Don't add after this line */
