 /*
  * Khoros: $Id: X3D.h,v 1.2 1991/07/15 06:00:37 khoros Exp $
  */

 /*
  * $Log: X3D.h,v $
 * Revision 1.2  1991/07/15  06:00:37  khoros
 * HellPatch1
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name:  X3D.h
   >>>>                     
   >>>>   description: All local #defines and structures for 
   >>>>			Khoros 3D Graphics Utilities --
   >>>>                       
   >>>>      routines: 	
   >>>>                
   >>>> modifications:
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xvinclude.h"	
#include "xvgraphics.h"	
#include "vsignal.h"	
#include "graphics.h"

#ifndef	 _X3D_h
#define  _X3D_h


/*
 * The X3DFont structure is used to hold a single character vector.
 */
typedef struct
        {
            char  ch;           /* the character represented */
            int   num;          /* number of points */
            Coord *points;  /* in range 0 - 1 */
        } X3DCharacter;

/*
 *  Create font structure
 */
typedef struct  _X3DFont
        {
	    unsigned int   num;
            char*	   fontname;
            Coord          wc_min, wc_max;     /* World Coordinate min & max */
            X3DCharacter   character[100];     /* characters */
            struct _X3DFont *next;
        } X3DFont;


#define FONTDIR		"KHOROS_HOME/repos/fonts"
#define TEXT_ID		-1


/*
 * The X3DGraphics structure contains all information needed to
 * map world coordinate values of an image or plot to the device 
 * coordinate values actually displayed on the graphics workstation.
 */

typedef  struct
	 {
	   int   id,		/* Identifies this X3D graphics structure */
		 win_type,	/* Tells if the graphics window is 2D or 3D */
		 line_type,	/* Tells line type */
		 line_width,	/* Tells line width */
		 projection,	/* Type of projection */
		 clipping_2D,	/* on or off for 2d clipping */
		 device;	/* type of ouput device (X,postscr,news,...) */

	   Real  alpha,		/* Angle describing the position of the eye
				   between Z axis and the XY plane */
	         theta,		/* Angle describing the position of the eye
				   around Z axis with respect to the XY plane */
	         eye_dist,	/* Distance of the eye from the object */
                 view_dist;    /* Distance of the eye from the viewport */

	   Matrix    matrix;	/* Final 3D output matrix in DC values */
	   Matrix_2D matrix2D;	/* Final 2D output matrix in DC values */

	   Real  xv_min, xv_max, /* X viewport min and max */
		 yv_min, yv_max, /* Y viewport min and max */
		 zv_min, zv_max; /* Y viewport min and max */

	   Coord smin, smax;    /* Saved World Coordinate min and max
				     vectors */
	   Coord wc_min, wc_max;  /* World Coordinate min and max vectors
				     according to the scale type */
	   Coord scale;		  /* Scale type wc space (ie LINEAR, LOG10,
				     LN, ...).				  */

	   Coord  center;	  /* Defines the center of projection */
	   Vector vpn;		  /* Defines view plane normal */

	   X3DFont *font;
	   int	    orientation,
		    justify;	  /* Text string justification */
	   Real	    spacing,	  /* Character spacing */
		    aspect;


	   /**  X11R4 Dependencies  **/
	   Display *display;
	   Window  workspace;
	   Widget  widget;
	   unsigned long fg, bg;

	   GC	   gc_draw, gc_fill;  /* GC's to draw and fill with */
	   short X11_xmin, X11_xmax,  /* X device coordinate min and max */
		 X11_ymin, X11_ymax;  /* Y device coordinate min and max */

	   /**  Postscript Dependencies  **/
	   FILE	 *pfile;		/* opened file for file output */
	   short POS_xmin, POS_xmax,  /* X device coordinate min and max */
		 POS_ymin, POS_ymax;  /* Y device coordinate min and max */
	   int   POS_mono;	      /* Monochrome output .vs. color */
	   int   POS_invert;	      /* Input the color or monochrome output */

	   /**  Impress Dependencies  **/
	   FILE	 *ifile;		/* opened file for file output */
	   short IMP_xmin, IMP_xmax,  /* X device coordinate min and max */
		 IMP_ymin, IMP_ymax;  /* Y device coordinate min and max */

	   /**  HPGL Dependencies  **/
	   FILE	 *hfile;		/* opened file for file output */
	   short HPGL_xmin, HPGL_xmax,  /* X device coordinate min and max */
		 HPGL_ymin, HPGL_ymax;  /* Y device coordinate min and max */

	 }  X3DGraphics;


typedef struct _X3DList
        {
           int          	id;
           X3DGraphics		*graphics;
           struct _X3DList      *next, *prev;
        }  X3DList;

/*
 *  Type definitions for X3D functions
 */
X3DGraphics	*_X3D_get_graphics();

Real		X3D_get_scale_value();

int		X3D_scale_wc_coord(),
		X2D_scale_wc_coord(),
		X3D_scale_wc_coords(),
		X2D_scale_wc_coords(),
		_X2D_convert_wc_to_dc(),
		_X2D_convert_wc_to_dc_seg(),
		_X3D_convert_wc_to_dc(),
		_X3D_convert_wc_to_dc_seg(),
		X2D_convert_point_wc_to_dc(),
		X3D_convert_point_wc_to_dc(),
		X3D_convert_point_wc_to_ndc3(),
		X3D_inquire_device();

vsignal		X3D_signal_handler();

/*
 *  Line Width definitions
 */

 /* Note this is dependent on the device defines and on the
  * line width defines. 
  * the order for the line widths are {X11, POSTSCRIPT, IMPRESS, HPGL}
  *
  * If a new device is added or a new line width is added, the
  * definitions below must be editted accordingly.
  */
static float 	extra_fine[]	= {0.0, 1.0, 1.0, 1.0},
                fine[]		= {1.0, 1.5, 1.0, 1.0},
		medium_fine[]	= {2.0, 2.0, 1.0, 1.0},
		medium[]	= {3.0, 2.5, 1.0, 1.0},
		medium_wide[]	= {4.0, 3.0, 1.0, 1.0},
		wide[]		= {5.0, 3.5, 1.0, 1.0},
		extra_wide[]	= {6.0, 4.0, 1.0, 1.0};

static float *line_widths[] = { extra_fine, fine, medium_fine, medium, 
                               medium_wide, wide, extra_wide };
		

/*
 *  Line type defintions
 */
static int      dash_len[]     = { 0, 0, 2, 4, 2, 2, 4, 2 };
static char     dummy[]        = { 0 },
		dotted[]       = { 2, 3 },
        	dot_dashed[]   = { 2, 3, 5, 3 },
        	short_dashed[] = { 5, 3 },
        	long_dashed[]  = { 8, 3 },
        	odd_dashed[]   = { 4, 3, 9, 3 },
        	grid_dotted[]   = { 1, 5 };

static char    *dash_type[]   =
{
        dummy, dummy, dotted, dot_dashed, short_dashed, long_dashed, odd_dashed, grid_dotted
};

jmp_buf jump_dest;

/*
 *   The following macro is used to interpolate between two points. 
 */
#define CINTRP(x0,x1,a0,a1,a2)   ( (a1) != (a0) \
	? ( (x0) + (((x1) - (x0))*((a2) - (a0))) / ((a1) - (a0)) ) \
	: ( ((x0) + (x1)) / 2.0 ))

/*	
 *  Multiply the vector by the matrix for 2D & 3D.
 */
#define _X2D_vector_mult(coord, m, xout, yout, wout)			      \
{									      \
	xout = coord.x*m[0][0] + coord.y*m[1][0] + m[2][0];		      \
	yout = coord.x*m[0][1] + coord.y*m[1][1] + m[2][1];		      \
	wout = coord.x*m[0][3] + coord.y*m[1][3] + m[2][3];		      \
}

#define _X3D_vector_mult(coord, m, xout, yout, zout, wout)		      \
{									      \
	xout = coord.x*m[0][0] + coord.y*m[1][0] + coord.z*m[2][0] + m[3][0]; \
	yout = coord.x*m[0][1] + coord.y*m[1][1] + coord.z*m[2][1] + m[3][1]; \
	zout = coord.x*m[0][2] + coord.y*m[1][2] + coord.z*m[2][2] + m[3][2]; \
	wout = coord.x*m[0][3] + coord.y*m[1][3] + coord.z*m[2][3] + m[3][3]; \
}


#define _X2D_DegToRads(degrees)  (atan(XV_PI/180.0)*degrees)
#define _X3D_DegToRads(degrees)  (atan(XV_PI/180.0)*degrees)

#undef  MAX
#define MAX(x,y) (((x) > (y)) ? (x) : (y))

#undef  MIN
#define MIN(x,y) (((x) < (y)) ? (x) : (y))

#undef  MIN4
#define MIN4(x0, x1, x2, x3) ((MIN(x0,x1) < MIN(x2,x3))	\
                                          ? MIN(x0,x1) : MIN(x2,x3))
#undef  MAX4
#define MAX4(x0, x1, x2, x3) ((MAX(x0,x1) > MAX(x2,x3))	\
					  ? MAX(x0,x1) : MAX(x2,x3))
#undef  ABS
#define	ABS(x)   (((x) < 0) ? (-(x)) : (x))

#undef  SQR
#define	SQR(x)   ((x)*(x))


#endif
/*  Don't add after endif  */
