 /*
  * Khoros: $Id: run_xprism3.c,v 1.3 1992/03/20 22:41:45 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_xprism3.c,v 1.3 1992/03/20 22:41:45 dkhoros Exp $";
#endif

 /*
  * $Log: run_xprism3.c,v $
 * Revision 1.3  1992/03/20  22:41:45  dkhoros
 * VirtualPatch5
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xprism3.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: run_xprism3.c
   >>>>               
   >>>>   description: drives the plot subform 
   >>>>              
   >>>>      routines:
   >>>>			run_xprism_3D
   >>>>			run_environment
   >>>>			run_input_file
   >>>>			run_perspective
   >>>>			run_transforms
   >>>>              
   >>>> modifications:
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#define MAXNAMELENGTH 30


/************************************************************
*
*  MODULE NAME: run_xprism_3D
*
*      PURPOSE: Drives the Xprism form -- 
*		Called after the user clicks on an "Xprism" action
*		button.
*		
*
*       OUTPUT: none
*
*    CALLED BY: run_master
*
*   WRITTEN BY: Mark Young, & Mike Lang, Tom Sauer
*
*
*************************************************************/

run_xprism_3D(form, xprism_info, marker_type, line_type, whichband, cmplx)

xvf_form	*form;
Master_xprism   *xprism_info;
int             marker_type, line_type, whichband, cmplx;
{
	/*
	 * get the form information structure indicating
	 * selections & and input provided by the user
	 */

	_xvf_get_xprism(form, xprism_info);

	if (xprism_info->quit)
	   xvf_change_active(form, false);


	/*
	 * action came from the 'input_file' pane
	 */
	else if (xprism_info->input_file_selected)
	    run_input_file(form, xprism_info->input_file, 
				marker_type, line_type, whichband, cmplx);

	/*
	 * action came from the 'input_function' pane
	 */
	else if (xprism_info->input_function_selected)
	    run_input_function(form, xprism_info->input_function,
				marker_type, line_type);

	/*
	 * action came from the 'transforms' pane
	 */
	else if (xprism_info->transforms_selected)
	    run_transforms(form, xprism_info->transforms);

	/*
	 * action came from the 'environment' pane
	 */
	else if (xprism_info->environment_selected)
	    run_environment(form, xprism_info->environment);

	XSync(display, FALSE);
}



/************************************************************
*
*  MODULE NAME: run_environment
*
*      PURPOSE: Drives the Environment pane of the Xprism form -- 
*		Called after the user clicks on "Set Environment",
*		it sets the Global Input Directory (global_indir)
*		and the Global Output Directory (global_outdir)
*		which have been previously set by the user on the
*		Environment pane, and passed back by xvforms
*		in the "form.environment" structure 
*		
*       INPUT:  form - pointer to the form tree
*               environ_info - pointer to the Environment Pane
*                               information structure
*
*       OUTPUT: none
*
*    CALLED BY: Main
*
*   WRITTEN BY: Danielle Argiro, Mark Young, & Mike Lang
*
*
*************************************************************/


run_environment(form, environ_info)

xvf_form      	   *form;
xprism_environment *environ_info;
{
	_xvf_get_environment(form, environ_info);

	if (global_indir != NULL)
	   free(global_indir);
	global_indir = xvf_strcpy(environ_info->input_path);

	if (global_outdir != NULL)
	   free(global_outdir);
	global_outdir = xvf_strcpy(environ_info->output_path);

	XVF_FILE_DIR = environ_info->input_path; 
}



/************************************************************
*
*  MODULE NAME: run_input_file
*
*
*      PURPOSE: Drives the Input pane of the Xprism form -- 
*		Called after the user clicks on "Plot",
*		It first determines which type of plot is desired
*		according to the plot type; then, according to whether 
*		the user has selected "Input Type" as a file,
*		it reads the file in order to
*		create the appropriate plot structure.  It then plots
*		the information provided, alone in a graphics workspace
*		if this was the first operation, or on top of the other
*		plots already there if it was not.
*
*       INPUT:  form - pointer to the form tree
*               input_info - pointer to the Input Pane information structure
*
*
*       OUTPUT: A new plot displayed in the graphics workspace
*
*    CALLED BY: main
*
*   WRITTEN BY: Danielle Argiro and Mark Young
*
*
*************************************************************/

run_input_file(form, input_file_info, marker_type, line_type, whichband, cmplx)

xvf_form        *form;
xprism_input_file    *input_file_info;
int             marker_type, line_type, whichband, cmplx;
{
        XPlot *plot, *get_input_file();
        int  plot_type, get_file_type();
        XawListReturnStruct *machine_list_return;
        char *prompt1 = "Pick Input Raw Data Machine Type";
        char *label1 = "Machine Type List";
        char *mach_name, **machine_list, *mesg;
        int col_num = 1, current, machorder();
        int i, nc, nr, machine_type_index;
        int machine_type, data_type, data_format;
	int begin_point_x, begin_point_y, end_point_x, end_point_y;
        int step_size_x, step_size_y;

    
	_xvf_get_input_file(form, input_file_info);

	/*
	 *  toggles start at 1, plot PLOT_3D starts at 1
	 */

	plot_type = input_file_info->change_plot_type_val;

	/*
         *   Change the Plot Type plot(s) currently displayed in the window
         */
        switch(input_file_info->data_type_val)
        {
           case 1:  /* BYTE */
              data_type = VFF_TYP_1_BYTE;
              break;
           case 2:  /* BYTE */
              data_type = VFF_TYP_2_BYTE;
              break;
           case 3:  /* BYTE */
              data_type = VFF_TYP_4_BYTE;
              break;
           case 4:  /* BYTE */
              data_type = VFF_TYP_FLOAT;
              break;
          default:
              xvf_error_wait("An unknown data type has been encountered.  Please select a valid data type", "run_input_file", NULL);
              break;
        }

        step_size_x = input_file_info->step_size_x;
        begin_point_x = input_file_info->begin_point_x;
        end_point_x = input_file_info->end_point_x;
        step_size_y = input_file_info->step_size_y;
        begin_point_y = input_file_info->begin_point_y;
        end_point_y = input_file_info->end_point_y;

        switch(input_file_info->data_format_val)
        {
           case 1:
              data_format = XYZ_TRIPLES;
              break;
           case 2:
              data_format = Z_ONLY;
              break;
           default:
              xvf_error_wait("An unknown data format has been encountered.  Please select a valid data format", "run_io_input", NULL);
              break;
        }


        /*
         * user clicked on pane action button 'machine_type'
         */

         /* since we do not save the machine type */

        if (input_file_info->machine_type)
        {
	    machine_list = getmachlist(&i);

            machine_list_return = xvf_run_list_wait(machine_list,
                                                    i-1,
                                                    col_num, prompt1,
                                                    label1, &current, False);
            if (machine_list_return == NULL) return;

            mach_name = VStrcpy(machine_list_return->string);

            machine_type = machorder(mach_name);
	    machine_type_index = find_machtype_index(mach_name);

            xvf_change_input(form, input_file_info->machine_type_index+1,
                                xvf_title_chng, mach_name, MAXNAMELENGTH);

            if (machine_type == 255)
            {
                xvf_error_wait("An unknown machine type has been encountered. Please select a valid machine type", "run_input_file", NULL);
               gwin_attr->machine_type_index = machine_type_index;
               return;
            }
            gwin_attr->machine_type_index = machine_type_index;
            return;
        }

	/*
         *   Input a new plot from a file
         */

	else if (input_file_info->plot_file)
	{
            plot = get_input_file(input_file_info->filename, plot_type,
                                  data_format, gwin_attr->machine_type_index, 
			   	  data_type, -1, whichband, cmplx);

	}  

	/* 
	 *  Create the graphics workspace if necessary, or add the
	 *  plot to the already-existent workspace 
	 */

	if (plot == NULL)
	   return;

        nc = plot->row_size;
        nr = plot->size/plot->row_size;

        if (end_point_x > nc            ||
            begin_point_x > nc          ||
            step_size_x > nc            ||
            (end_point_x <  begin_point_x         &&
             end_point_x > 0 && begin_point_x >0) ||
            step_size_x == 0.0			||
            end_point_y > nr            ||
            begin_point_y > nr          ||
            step_size_y > nr            ||
            (end_point_y <  begin_point_y         &&
             end_point_y > 0 && begin_point_y >0) ||
            step_size_y == 0.0)
        {
             freeplot(plot);
             mesg = xvf_strcpy("The Begin point, End point or Step Size was specified incorrectly.\n\nPlease check the Begin point, End point and Step Size, and Plot Data again");
                xvf_error_wait(mesg, "run_input_file", NULL);
                free(mesg);
		return;
	}

        if (gwin == NULL)
	{
            gwin = create_new_gwin(plot, plot_type, marker_type, line_type,
                   step_size_x, begin_point_x, end_point_x, 0,
                   step_size_y, begin_point_y, end_point_y, NULL, 1);
	}
        else
	{
            assign_plot_to_gwin(plot, plot_type, marker_type, line_type,
                   step_size_x, begin_point_x, end_point_x, 0,
                   step_size_y, begin_point_y, end_point_y, NULL, 1);

/* CLIPPING: remove comment when clipping has been done

            mesg = xvf_strcpy("Do you want to RESET the Min/Max of the Plot Area to the New Plot's min/max?");
            if (xvf_warn_wait(mesg, "RESET AXES", "YES","NO"))
            {
	        gwin->num_tics.x = 3;
                gwin->num_tics.y = 3;
                gwin->num_tics.z = 4;
                set_world_coordinates(plot->WCmin, plot->WCmax, gwin->num_tics);
            }
            free(mesg);
CLIPPING: remove comment when clipping has been done */

/* CLIPPING: remove the following 2 lines when clipping is done */
	   find_wc_min_max();
           reset_world_coordinates();
	}

	plot_routine();
	return;

} /* end run_input */



/********************************************************
*
*  Routine Name:  run_input_function
*
*       Purpose:  drives the pane 'input_function'
*
*         Input:  form - pointer to the form tree 
*		  input_function_info  - information structure for pane 'input_function'
*        Output:  action of the application program
*
*     Called By:  run_xprism()
*
*     WRITTEN BY: Danielle Argiro, Mark Young, Tom Sauer
*
********************************************************/


run_input_function(form, input_function_info, marker_type, line_type)

xvf_form        *form;
xprism_input_function    *input_function_info;
int             marker_type, line_type;
{
	XPlot *plot, *get_function();
	int  plot_type;
	char *function, *mesg, *x_range, *y_range, error[1024];
	char temp[2048];
	int begin_point_x, end_point_x, begin_point_y, end_point_y;
        int step_size_x, step_size_y, nc,nr;

    
	_xvf_get_input_function(form, input_function_info);

	/*
	 *  toggles start at 1, plot PLOT_3D starts at 1
	 */

	plot_type = input_function_info->change_plot_type_val;

        step_size_x = input_function_info->step_size_x;
        step_size_y = input_function_info->step_size_y;
        begin_point_x = input_function_info->begin_point_x;
        begin_point_y = input_function_info->begin_point_y;
        end_point_x = input_function_info->end_point_x;
        end_point_y = input_function_info->end_point_y;

        if (input_function_info->plot_function)
        {
	    if (gwin != NULL)
	    {
	        if (gwin->plotnum > 19)
	        {
		    mesg = xvf_strcpy("Sorry... we only allow 20 plots in the workspace\n");
		    xvf_error_wait(mesg, "run_input_function", NULL);
            	    free(mesg);
		    return;
	        }
	    }
	    sprintf(temp,"f(x,y) = %s",input_function_info->function);
	    function = xvf_strcpy(temp);
	    sprintf(temp,"x = (%s,%s,%s)",
                    input_function_info->x_min,input_function_info->x_max,
		    input_function_info->xnum_pts);
	    x_range = xvf_strcpy(temp);
	    sprintf(temp,"y = (%s,%s,%s)",
                    input_function_info->y_min,input_function_info->y_max,
		    input_function_info->ynum_pts);
	    y_range = xvf_strcpy(temp);

	    plot = get_function(plot_type, function, x_range, y_range, error);
	}

	/* 
	 *  Create the graphics workspace if necessary, or add the
	 *  plot to the already-existent workspace 
	 */

	if (plot == NULL)
	{
	   xvf_error_wait(error, "run_input_function", NULL);
	   return;
	}

        nc = plot->row_size;
        nr = plot->size/plot->row_size;

	if (((nc == 1) || (nr == 1)) && 
	   (plot->plot_type != PLOT_3D && 
	    plot->plot_type != PLOT_SCATTER &&
	    plot->plot_type != PLOT_IMPULSE))
	{
	     xvf_error_wait(
	   	   "start_cmd_plot_3D: Warning, This plot requires at least 2 rows and columns\nfor specified plot type. Resetting plot type to 3D\n",
		   "run_input_function", NULL);
		plot_type =
		plot->plot_type = PLOT_3D;
        }

        if (end_point_x > nc            ||
            begin_point_x > nc          ||
            step_size_x > nc            ||
            (end_point_x <  begin_point_x         &&
             end_point_x > 0 && begin_point_x >0) ||
            step_size_x == 0.0			||
            end_point_y > nr            ||
            begin_point_y > nr          ||
            step_size_y > nr            ||
            (end_point_y <  begin_point_y         &&
             end_point_y > 0 && begin_point_y >0) ||
            step_size_y == 0.0)
        {
             freeplot(plot);
             mesg = xvf_strcpy("The Begin point, End point or Step Size was specified incorrectly.\n\nPlease check the Begin point, End point and Step Size, and Plot Data again");
                xvf_error_wait(mesg, "run_input_function", NULL);
                free(mesg);
		return;
	}

        if (gwin == NULL)
	{
            gwin = create_new_gwin(plot, plot_type, marker_type, line_type,
                   step_size_x, begin_point_x, end_point_x, 0,
                   step_size_y, begin_point_y, end_point_y, NULL, 1);
	}
        else
	{
            assign_plot_to_gwin(plot, plot_type, marker_type, line_type,
                   step_size_x, begin_point_x, end_point_x, 0,
                   step_size_y, begin_point_y, end_point_y, NULL, 1);

/* CLIPPING: remove comment when clipping has been done

            mesg = xvf_strcpy("Do you want to RESET the Min/Max of the Plot Area to The New Plot's min/max?");
            if (xvf_warn_wait(mesg, "RESET AXES", "YES","NO"))
            {
	        gwin->num_tics.x = 3;
                gwin->num_tics.y = 3;
                gwin->num_tics.z = 4;
                set_world_coordinates(plot->WCmin, plot->WCmax, gwin->num_tics);
            }
            free(mesg);
CLIPPING: remove comment when clipping has been done */

/* remove the following 2 lines when clipping is done */
	   find_wc_min_max();
           reset_world_coordinates();
	}

	plot_routine ();
	return;

} /* end run_input */



/************************************************************
*
*  MODULE NAME: run_transforms
*
*
*      PURPOSE: Drives the Transforms pane of the Xprism form -- 
*		Called after the user clicks on "Transform Plot(s)",
*		It rotates, scales, translates, according to which
*		options are activated.  It then redisplays the plot(s).
*
*       OUTPUT: A new plot displayed in the graphics workspace
*
*    CALLED BY: main
*
*   WRITTEN BY: Danielle Argiro and Mark Young
*
*
*************************************************************/

run_transforms(form, transform_info)

xvf_form            *form;
xprism_transforms   *transform_info;
{
	char *mesg;
	float xval, yval, zval;
	int   trans_type;
	XPlot *plot;

	_xvf_get_transforms(form, transform_info);

	if (gwin == NULL)
	{
	   mesg = xvf_strcpy("\nCannot do transforms unless plot(s) are displayed!\n");
	   xvf_error_wait(mesg, "run_transforms", NULL);
	   free(mesg);
	   return;
	}

	if (transform_info->transform_plots)
	{
            xval = transform_info->x_val;
            yval = transform_info->y_val;
            zval = transform_info->z_val;
            trans_type = transform_info->trans_type_val;
            
            /* rotate */
            if (trans_type == ROTATE)
            {
                if ((xval > 360) || (yval > 360) || (zval > 360))
                {
                   mesg = xvf_strcpy("Can't rotate by more than 360 degrees");
                    xvf_error_wait(mesg, "run_transforms", NULL);
                    free(mesg);
                    return;
                }
                if ((xval < -360) || (yval < -360) || (zval < -360))
                {
                  mesg = xvf_strcpy("Can't rotate by less than -360 degrees");
                    xvf_error_wait(mesg, "run_transforms", NULL);
                    free(mesg);
                    return;
                }

                plot = get_a_plot("Select a plot to rotate" , "Rotate Plot",
                            APPEND_PLOT_TYPE);
		if (plot == NULL) return;
                rotate_3D(xval, yval, zval, plot);
            }
            
            	
            /* scale */
            else if (trans_type == SCALE)
            {
                if ((xval == 0) || (yval == 0) || (zval == 0))
                {
                    mesg = xvf_strcpy("Can't scale by 0 \n");
                    xvf_error_wait(mesg, "run_transforms", NULL);
                    free(mesg);
                    return;
                }
		plot = get_a_plot("Select a plot to scale" , "Scale Plot",
                            APPEND_PLOT_TYPE);
                if (plot == NULL) return;
                scale_3D(xval, yval, zval, plot);
            }
           
           	
            /* translate */
            else if (trans_type == TRANSLATE)
            {
                plot = get_a_plot("Select a plot to translate","Translate Plot",
                            APPEND_PLOT_TYPE);
                if (plot == NULL) return;
               translate_3D(xval, yval, zval, plot);
            }

	reset_world_coordinates();
	plot_routine();

	}

} /* end run_transforms */



