/*    
  readmesh.c
  
  read a file telling about input and background textures, 
  number of morphing steps, etc.
  
  */

#include  "globals.h"

#include <string.h>

#define morphBSIZE 256

int linenumber;


char *getnonblank(line, maxsize, fp)
FILE *fp;
char *line;
int maxsize;
{
   char *ptr;
   static char blanks[5] = {32, 9, 10, 13, 0};
   
   linenumber++;
   ptr=fgets(line, maxsize, fp);
   if (!ptr) 
   {
      fprintf(stderr, "unexpected EOF in line %d\n", linenumber);
      exit(0);
   }
   
   for (ptr = &line[strspn(line, blanks)]; !strlen(ptr); )
   {
      linenumber++;
      ptr=fgets(line, maxsize, fp);
      if (!ptr) 
      {
	 fprintf(stderr, "unexpected EOF at line number %d\n", linenumber);
	 exit(0);
      }
      ptr = &line[strspn(line, blanks)];
      
   }
   
   return(ptr);
}




readmeshes(filename)
char *filename;
{
   FILE *fp, *fopen();
   char line[morphBSIZE];   /* buffer */
   char *ptr;
   int i, j, numread;
   
   /* open a file */
   fp = fopen(filename, "r");
   if (fp == NULL)
   {
      fprintf(stderr, "can't open mesh file '%s'\nbye.\n", filename);
      exit(0);
   }
   
   linenumber = 0;
   CLOSEdist = 6;    /* default */
   OUTPUTGIFS = 0;  /* false, default */


   for (;;)
   {
      /* read a line at a time */
      ptr=getnonblank(line,morphBSIZE,fp);
      
      if (strlen(ptr)) ptr[strlen(ptr)] = '\0'; /* remove newline ? */
      /*if (DEBUG) fprintf(stderr, "ptr='%s'\n", ptr);*/
      
      if (strlen(ptr))
      {
	 ptr[strlen(ptr)-1] = '\0'; /* remove newline ? */
	 
	 if (!strncmp("starttexture", ptr, 12))
	 {
	    starttexfile = calloc(1,80);
	    sscanf(line, "starttexture %s\n", starttexfile);
	    /*fprintf(stderr, "starttexfile = '%s'\n", starttexfile);*/
	 }
	 
	 else if (!strncmp("endtexture", ptr, 10))
	 {
	    endtexfile = calloc(1,80);
	    sscanf(line, "endtexture %s\n", endtexfile);
	    /*fprintf(stderr, "endtexfile   = '%s'\n", endtexfile);*/
	 }
	 
	 else if (!strncmp("backgroundtexture", ptr, 17))
	 {
	    backtexfile = calloc(1,80);
	    sscanf(line, "backgroundtexture %s\n", backtexfile);
	    /*fprintf(stderr, "backtexfile  = '%s'\n", backtexfile);*/
	 }
	 
	 else if (!strncmp("numtris", line, 6))
	 {
	    sscanf(line, "numtris %d\n", &nummesh);
	    fprintf(stderr, "%d triangles\n", nummesh);
	 }
	 
	 else if (!strncmp("colordiff", line, 9))
	 {
	    sscanf(line, "colordiff %d\n", &CLOSEdist);
	    fprintf(stderr, "color distance %d\n", CLOSEdist);
	 }
	 
	 else if (!strncmp("steps", line, 5))
	 {
	    sscanf(line, "steps %d\n", &numsteps);
	    fprintf(stderr, "%d morphing steps\n", numsteps);
	 }
	 else if (!strncmp("outputgifs", line, 10))
	 {
	    sscanf(line, "outputgifs %s\n", outgiffilename);
	    fprintf(stderr, "writing gif files '%s'\n", outgiffilename);
	    OUTPUTGIFS = -1; /* true */
	 }
	 else   
	 {
	    if (DEBUG) fprintf(stderr, "triangle data\n");
	    /* assume triangle data, should crap out if we got here by typo */
	    
	    /* begin texture coords, from & to */
	    for (j=0; j<=1; j++)       /* 0=FROM   1=TO */
	    {
	       for (i=0; i<nummesh; i++)
	       {
		  /* ugly, but we were 1 line ahead of ourselves */
		  if (i || j) ptr=getnonblank(line, morphBSIZE, fp);
		  
		  numread=sscanf(ptr, "%lf %lf  %lf %lf  %lf %lf\n", 
				 &beginmesh[j][i][0].x,&beginmesh[j][i][0].y, 
				 &beginmesh[j][i][1].x,&beginmesh[j][i][1].y, 
				 &beginmesh[j][i][2].x,&beginmesh[j][i][2].y);
		  
		  if (numread != 6)
		  {
		     fprintf(stderr,"file format error:expecting 3 xy coords");
		     fprintf(stderr, "\nline %d of file '%s' = '%s'\n", 
			     linenumber, filename, line);
		     exit(0);
		  }
		  
		  if (DEBUG) fprintf(stderr, "beginmesh %d %d  %d %d  %d %d\n", 
				     (int)&beginmesh[j][i][0].x,
				     (int)&beginmesh[j][i][0].y, 
				     (int)&beginmesh[j][i][1].x,
				     (int)&beginmesh[j][i][1].y, 
				     (int)&beginmesh[j][i][2].x,
				     (int)&beginmesh[j][i][2].y);
		  
	       }
	       if (DEBUG) fprintf(stderr, "\n");
	    }
	    
	    
	    
	    
	    /* end texture coords */
	    for (j=0; j<=1; j++)       /* 0=FROM   1=TO */
	    {
	       for (i=0; i<nummesh; i++)
	       {
		  ptr=getnonblank(line, morphBSIZE, fp);
		  numread=sscanf(ptr, "%lf %lf  %lf %lf  %lf %lf\n", 
				 &endmesh[j][i][0].x,&endmesh[j][i][0].y, 
				 &endmesh[j][i][1].x,&endmesh[j][i][1].y, 
				 &endmesh[j][i][2].x,&endmesh[j][i][2].y);
		  
		  if (numread != 6)
		  {
		     fprintf(stderr,"file format error:expecting 3 xy coords");
		     fprintf(stderr, "\nline %d of file '%s' = '%s'\n", 
			     linenumber, filename, line);
		     exit(0);
		  }
		  if (DEBUG) fprintf(stderr, "endmesh %d %d  %d %d  %d %d\n", 
				     (int)&endmesh[j][i][0].x,
				     (int)&endmesh[j][i][0].y, 
				     (int)&endmesh[j][i][1].x,
				     (int)&endmesh[j][i][1].y, 
				     (int)&endmesh[j][i][2].x,
				     (int)&endmesh[j][i][2].y);
		  
	       }
	       if (DEBUG) fprintf(stderr, "\n");
	    }
	    
	    
	    /* output coordinates  (start and ending */
	    for (j=0; j<2; j++)
	    {
	       /* original coordinates in output */
	       for (i=0; i<nummesh; i++)
	       {
		  ptr=getnonblank(line, morphBSIZE, fp);
		  numread=sscanf(ptr, "%lf %lf  %lf %lf  %lf %lf\n", 
				 &outmesh[j][i][0].x,&outmesh[j][i][0].y, 
				 &outmesh[j][i][1].x,&outmesh[j][i][1].y, 
				 &outmesh[j][i][2].x,&outmesh[j][i][2].y);
		  
		  if (numread != 6)
		  {
		     fprintf(stderr,"file format error:expecting 3 xy coords");
		     fprintf(stderr, "\nline %d of file '%s' = '%s'\n", 
			     linenumber, filename, line);
		     exit(0);
		  }
		  if (DEBUG) 
		     fprintf(stderr, "outmesh %d %d  %d %d  %d %d\n", 
			     (int)outmesh[j][i][0].x,(int)outmesh[j][i][0].y, 
			     (int)outmesh[j][i][1].x,(int)outmesh[j][i][1].y, 
			     (int)outmesh[j][i][2].x,(int)outmesh[j][i][2].y);
	       }
	       if (DEBUG) fprintf(stderr, "\n");
	       
	    }
	    
	    break;
	 }
	 
	 /* probably unnecessary: clear the input line */
	 ptr = line;
	 for (i=0; i<morphBSIZE; i++) *ptr++ = '\0';
	 
      }
      
   }
   
   
   if (nummesh <= 0 || numsteps <= 0) 
   {
      fprintf(stderr, "probable file format error: numtris=%d numsteps=%d\n",
	      nummesh, numsteps);
      exit(0);
   }
   
   
   
}
