/* xmesaP.h */

/*
 * Mesa 3-D graphics library
 * Version:  1.2
 * Copyright (C) 1995  Brian Paul  (brianp@ssec.wisc.edu)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
$Id: xmesaP.h,v 1.11 1995/05/31 14:59:55 brianp Exp $

$Log: xmesaP.h,v $
 * Revision 1.11  1995/05/31  14:59:55  brianp
 * shm field not dependent on SHM symbol
 *
 * Revision 1.10  1995/05/22  20:59:34  brianp
 * Release 1.2
 *
 * Revision 1.9  1995/04/17  13:57:14  brianp
 * changed to support GLXPixmaps
 *
 * Revision 1.8  1995/03/30  21:10:12  brianp
 * replaced colorpacking with pixelformat
 *
 * Revision 1.7  1995/03/22  21:38:17  brianp
 * *** empty log message ***
 *
 * Revision 1.6  1995/03/13  20:56:23  brianp
 * removed drawbuffer and readbuffer fields
 *
 * Revision 1.5  1995/03/08  15:10:02  brianp
 * added support for dd_logicop
 * added dd_clear_index and dd_clear_color
 *
 * Revision 1.4  1995/03/07  14:21:36  brianp
 * updated for new XSetForeground/GC scheme
 *
 * Revision 1.3  1995/03/04  19:25:29  brianp
 * 1.1 beta revision
 *
 * Revision 1.2  1995/03/02  19:31:42  brianp
 * added defines for FRONT_PIXMAP, BACK_PIXMAP, and BACK_XIMAGE
 *
 * Revision 1.1  1995/02/28  21:23:31  brianp
 * Initial revision
 *
 */


#ifndef XMESAP_H
#define XMESAP_H


#ifdef SHM
#  include <X11/extensions/XShm.h>
#endif



/*
 * This struct is used by xmesa.c and glx.c only!
 */



struct xmesa_context {
        struct gl_context *gl_ctx;	/* the main library context */

	GLboolean initialized;	/* Is this context initialized yet? */

	GLuint db_state;	/* 0 = single buffered */
				/* BACK_PIXMAP = use Pixmap for back buffer */
				/* BACK_XIMAGE = use XImage for back buffer */

	Display *display;	/* the X11 display */
	Visual *visual;		/* the X11 visual */

	GC gc1;			/* GC for infrequent color changes */
	GC gc2;			/* GC for frequent color changes */
	GC cleargc;		/* GC for clearing the color buffer */

	GLuint dest;		/* Which buffer(s) to render into: */
				/* bitwise-OR of FRONT_PIXMAP, BACK_PIXMAP */
				/* and BACK_XIMAGE. */

	Drawable frontbuffer;	/* either a window or pixmap */
	Pixmap backpixmap;	/* back buffer Pixmap */
	XImage *backimage;	/* back buffer XImage */

	Drawable drawable;	/* ==window or ==backpixmap */

	Drawable readable;	/* IF readable==window THEN		*/
				/*	read from window		*/
				/* ELSE IF readable==backpixmap THEN	*/
				/*	read from backpixmap		*/
				/* ELSE	IF readable==NULL		*/
				/*	read from backimage		*/
				/* ENDIF				*/

	GLuint shm;		/* X Shared Memory extension status:	*/
				/*    0 = not available			*/
				/*    1 = XImage support available	*/
				/*    2 = Pixmap support available too	*/
#ifdef SHM
	XShmSegmentInfo shminfo;
#endif

	GLuint width, height;	/* size of buffer */
	GLuint depth;		/* bits per pixel (1, 8, 24, etc) */
	unsigned long pixel;	/* current color index or RGBA pixel value */
	unsigned long clearpixel; /* pixel for clearing the color buffers */

	GLuint pixelformat;	/* One of PF_ */

	/* IF pixelformat==PF_COLOR THEN */
		GLint rmult, gmult, bmult, amult;	/* Multiplier */
		GLint rshift, gshift, bshift, ashift;	/* Bit shifts */
	/* ELSE IF pixelformat==PF_8BIT THEN */
		unsigned long color_table[256];
		unsigned long red_table[256],green_table[256],blue_table[256];
	/* ENDIF */

};


#endif
