
Distance::usage = "Distance[p, q] is the length of the segment from the point 
p to the point q. Distance[p, l] (or Distance[l, p]) gives the distance from 
the point p to the line l."

Distance[_, {}] := Infinity

Distance[{}, _] := Infinity

Distance[p_, q_] := Norm[q - p] 

Distance[p_, l_Line] := Distance[p, Project[p, l]] 

Distance[l_Line, p_] := Distance[p, l]

Distance[p_, w_Plane] := Distance[p, Project[p, w]]

Distance[w_Plane, p_] := Distance[p, w]

