
PreDrawzx::usage = "PreDrawzx[f] prepares the figure f for drawing."

PreDrawzx @ Point[{x_, y_}] := Point[{0, x}]

PreDrawzx @ Point[{x_, y_, z_}] := Point[{z, x}]

PreDrawzx @ Line @ h_ := Line[Take[RotateRight[#], 2] & /@ h] 

PreDrawzx @ Polygon @ h_ := Polygon[Take[RotateRight[#], 2] & /@ h] 

( PreDrawzx @ Circle[c_, r_] := 
	PreDrawzx @ Line @ Map[c + r (Cos[#] $k + Sin[#] $i) &, 
	2 N[Pi] Range[0, 1, 1 / PointsOnCircle]] )

PreDraw @ u_Circle3D := PreDrawzx @ PreDraw3D @ u

PreDraw @ w_Plane := PreDrawzx @ PreDraw3D @ w

PreDrawzx @ Sphere[{a_, b_, c_}, r_] := PreDrawzx @ Circle[{c, a, 0}, r] 

( PreDrawzx @ d_Disk := Block[
	{c = PreDrawzx[Circle @@ d]},
	{Polygon @@ c, RGBColor[0, 0, 0], c} ] )

( PreDrawzx[m_] := m 
	/; MemberQ[{GrayLevel, RGBColor, PointSize, AbsolutePointSize, 
	Thickness, AbsoluteThickness, Dashing}, Head @ m] )

PreDrawzx @ Text[x_, c_, d___] := Text[x, Take[RotateRight[c], 2], d]

PreDrawzx @ EdgeForm[___] := {}

PreDrawzx @ h_List := PreDrawzx /@ h

Drawxz[f_, opts___] := Show @ Graphics[PreDrawzx @ Reverse @ f, opts]

