(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Bool.m3                                               *)
(* Last Modified On Mon Mar  2 10:30:44 PST 1992 By kalsow     *)
(*      Modified On Mon Nov 27 15:21:12 1989 By muller         *)

MODULE Bool;

IMPORT Expr, EnumType, EnumElt, Scope, M3;
IMPORT String, Tipe, Constant, EnumExpr;

VAR true, false: Expr.T;

PROCEDURE Initialize () =
  VAR elts: Scope.T;  cs := M3.OuterCheckState;
  BEGIN
    elts := Scope.PushNew (FALSE, String.Add ("BOOLEAN"));
    T := EnumType.New (2, elts);
    False := EnumElt.New (String.Add ("FALSE"), 0, T);
    Scope.Insert (False);
    True := EnumElt.New (String.Add ("TRUE"), 1, T);
    Scope.Insert (True);
    Scope.PopNew ();
    Scope.TypeCheck (elts, cs);
    Tipe.Define ("BOOLEAN", T, TRUE);
    false := EnumExpr.New (T, 0);
    Constant.Declare ("FALSE", false, TRUE);
    true := EnumExpr.New (T, 1);
    Constant.Declare ("TRUE", true, TRUE);
    Map[FALSE] := EnumExpr.New (T, 0);
    Map[TRUE] := EnumExpr.New (T, 1);
  END Initialize;

BEGIN
END Bool.
