(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Wed Jan 22 16:52:59 PST 1992 by kalsow     *)
(*      modified on Wed Jul  3 04:15:39 1991 by muller         *)


INTERFACE RTHeapPolicy;

(* This interface provides access to parameters that tune the
   the garbage collector. *)



(*
   When a collection completes, the heap will be expanded if the
   number of free pages is less than

      MAX (recoveryRatio * #allocated pages, minRecovery, #needed)

   where "#needed" is the number of pages needed to satisfy the
   allocation request that triggered the garbage collection.
*)

VAR
  minRecovery := 128;
  (* minimum number of free pages after a collection that doesn't also
     trigger a heap expansion *)

VAR
  recoveryRatio := 0.3;
  (* minimum number of free pages after a collection, as a ratio of the total
     number of pages, that doesn't also trigger a heap expansion *)



(*
   When the heap expands, the number of new pages is

      MAX (GrowthRate * #allocated pages, minIncrement, #needed)

   where "#needed" is the number of pages needed to satisfy the
   allocation request that triggered the garbage collection that triggered
   the heap expansion (that's connected to the knee bone...).
*)

VAR
  minIncrement := 128;
  (* minimum number of new pages added when the heap is expanded.
     Note that half of these pages are in "from" space and half in
     "to" space. *)

VAR
  growthRate := 0.3;
  (* the minimum number of new pages added to the heap when it expands
     given as a faction of the current heap size  *)

END RTHeapPolicy.
