(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Jan 31 08:54:11 PST 1992 by kalsow         *)
(*      modified on Tue Sep 25 00:38:09 1990 by muller         *)

(* This interface provides a safe interface to the runtime
   type system.  *)

INTERFACE RTType;

IMPORT RT0;

TYPE
  Typecode = RT0.Typecode;
  (* Each object and traced reference type is assigned a unique
     typecode.  A typecode is "proper" if it lies in the range
     [0..MaxTypecode()].  The proper typecodes include all those
     that correspond to types.  Other typecodes are used internally
     by the runtime system and garbage collector.
     *)

CONST
  NoSuchType : Typecode = LAST (Typecode);
  (* a reserved typecode that represents unknown types *)

PROCEDURE MaxTypeCode (): Typecode;
(* returns the largest proper typecode *)

PROCEDURE IsSubtype (tc1, tc2: Typecode): BOOLEAN;
(* returns TRUE iff the type corresponding to tc1 is a subtype
   of the type corresponding to tc2.  It is a checked runtime
   error to pass improper typecodes. *)

(*------------------------  tracing  ----------------------------*)

TYPE
  RefType    = RT0.RefType;
  RefTypeSet = RT0.RefTypeSet;
  VisitProc  = RT0.VisitProc;
  (* NOTE: VisitProcs must be top-level procedures *)

CONST
  AllRefTypes = RefTypeSet { RefType.Traced, RefType.Untraced, RefType.Proc };
  TracedRefTypes = RefTypeSet { RefType.Traced };

PROCEDURE Visit (arg, r: REFANY;  p: VisitProc;
                 mask: RefTypeSet := AllRefTypes) RAISES ANY;
(* for each field, f, of r^ that is a reference and whose type is
   included in mask, call "p (arg, ADDR(r^.f), ADDR (r^), typeof (f))".
   The type of r^.f is passed to p and determines the interpretation
   of the field parameter:

|      type       field
|      ------     ---------
|      Traced     UNTRACED REF REFANY
|      Untraced   UNTRACED REF ADDRESS
|      Proc       UNTRACED REF ADDRESS { really a PROCEDURE }

   It is a checked runtime error if r is NIL or p is not a top-level
   procedure.  Visit can raise only the exceptions raised by p. *)

(*------------------------------------------------------------------ setup --*)

PROCEDURE Init ();
(* Init is only called by RTMain.Run. *)

END RTType.
