//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: MBN 09/18/89 -- Changed package names to uppercase
// Updated: LGO 09/20/89 -- Split everything into separate files.
// Updated: MJF 02/22/90 -- Removed exception handlers on stack.
//     
// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

IMPLEMENT_GENERIC(Exception)
IMPLEMENT_GENERIC(Warning)
IMPLEMENT_GENERIC(System_Signal)
IMPLEMENT_GENERIC(Fatal)
IMPLEMENT_GENERIC(Error)
IMPLEMENT_GENERIC(System_Error)
IMPLEMENT_GENERIC(Verify_Error)
IMPLEMENT_GENERIC(Excp_Handler)

Exception* Exception_g;  // global exception used by EXCEPTION macro

// ***************************************************************************
// COOL is set up with Exception Handlers established for Exceptions of type
// Fatal, Error, Warning, System_Error and System_Signal.
// ** This is now done with default_handler member function. **
// ***************************************************************************
//
// Excp_Handler warn_eh(warn_handler, SYM(Warning));
// Excp_Handler exit_eh(exit_handler, SYM(Error));
// Excp_Handler abort_eh(abort_handler, SYM(Fatal));
// Excp_Handler sys_err_eh(system_error_handler, SYM(System_Error));
// Excp_Handler sys_sig_eh(system_signal_handler, SYM(System_Signal));
