//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: MBN 09/18/89 -- Changed SYM package name to uppercase
// Updated: LGO 09/20/89 -- Split into separate file.
// Updated: MJF 02/23/90 -- Changed to use array of exceptions slot.

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

#if defined(DOS)
extern "C" {
#include <stdlib.h>				// For exit()
}
#else
#include <stdlib.h>				// For exit()
#endif

// **********************************************************************
// Constructor for the Excp_Handler class
// **********************************************************************

// exit_handler(Exception*) --  An Exception Handler function which reports
//                              the error message and terminates program
//                              normally with exit().
//                              Used by Excp_Handler::Excp_Handler().
// INPUT:   An Exception pointer.
// OUTPUT:  None.

void exit_handler(Exception* excp) {
  excp->report(cerr);		// report error message
  exit(1);			// and terminates in error with exit.
}


// Excp_Handler()  -- an Exception Handler constructor which initializes with
//                    defaults for the Exception type and Excp Handler function.
//
// Input:   None.
// Output:  None.

Excp_Handler::Excp_Handler() {
  this->eh_func = exit_handler;		// default Excp Handler will exit()

  this->excp_types = (Excp_Type*) new Excp_Type[2];
  this->excp_types[0] = SYM(Error);	// default handles Error exception
  this->excp_types[1] = NULL;		// NULL terminated array

  this->next_handler = this->top_handler;  
  this->top_handler = this;
}
