//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/List.h>
#include <test.h>

DECLARE List<int>;

// *****************
// List of int tests
// *****************

void list_int_set_test1() {
  List<int> ltemp1;
  List<int> l1;
  List<int> l2(4,11,22,33,44);
  List<int> l3(2,22,33);
  List<int> l4(5,11,22,33,44,55);

  TEST("l2.find(33)", (l2.find(33) && l2.value()==33), TRUE);
  TEST("l2.find(2)", l2.find(2), FALSE);

  TEST("l2.search(l3)", (l2.search(l3) && l2.value()==22), TRUE);
  TEST("l2.search(l1)", l2.search(l1), FALSE);
  TEST("l2.search(l4)", l2.search(l4), FALSE);
  TEST("l4.search(l2)", (l4.search(l2) && l4.value()==11), TRUE);
  TEST("l1.search(l2)", l1.search(l2), FALSE);

  TEST_RUN("l2.member(ltemp1, 22)", l2.member(ltemp1, 22),
	   (ltemp1.length()==3, ltemp1[0]==22 && ltemp1[1]==33, ltemp1[2]==44
	    && l2.value()==22),
	   TRUE);
  TEST_RUN("l2.member(ltemp1, 44)", l2.member(ltemp1, 44),
	   (ltemp1.length()==1 && ltemp1[0]==44 && l2.value()==44),
	   TRUE);
  TEST_RUN("l2.member(ltemp1, 3)", l2.member(ltemp1, 3), (ltemp1.length()==0),
	   TRUE);

  TEST_RUN("l2.sublist(ltemp1, l3)", l2.sublist(ltemp1, l3),
	   (ltemp1.length()==3 && ltemp1[0]==22, ltemp1[1]==33, ltemp1[2]==44
	    && l2.value()==22),
	   TRUE);
  TEST_RUN("l2.sublist(ltemp1, l1)", l2.sublist(ltemp1, l1),
	   (ltemp1.length()==0), TRUE);
  TEST_RUN("l2.sublist(ltemp1, l4)", l2.sublist(ltemp1, l4), 
	   (ltemp1.length()==0), TRUE);
  TEST_RUN("l4.sublist(ltemp1, l2)", l4.sublist(ltemp1, l2), 
	   (ltemp1==l4 && l4.value()==11), TRUE);
  TEST_RUN("l1.sublist(ltemp1, l2)", l1.sublist(ltemp1, l2), 
	   (ltemp1.length()==0), TRUE);
}

void list_int_set_test2() {
  List<int> ltemp1;
  List<int> l5(12,1,55,3,88,77,44,33,22,11,66,2,3);
  List<int> l6(5,11,66,111,33,55);

  ltemp1 = List<int>(4,55,33,11,66);
  TEST_RUN("l5.intersection(l6)", l5.intersection(l6), (l5==ltemp1), TRUE);

  ltemp1 = List<int>(5,111,55,33,11,66);
  TEST_RUN("l5.lunion(l6)", l5.lunion(l6), (l5==ltemp1), TRUE);

  TEST_RUN("l5.difference(l6)", ltemp1.clear(); l5.difference(l6), 
	   (l5==ltemp1), TRUE);

  ltemp1 = List<int>(5,11,66,111,33,55);
  TEST_RUN("l5.exclusive_or(l6)", l5.exclusive_or(l6), (l5==ltemp1), TRUE);

}

void list_int_set_test3() {
  List<int> ltemp1;
  List<int> l7(2,2,3);
  List<int> l8(3,1,2,3);
  List<int> l9 = l7 + l8;
  List<int> l10(3,4,5,6);
  List<int> l11(12,1,55,3,88,77,44,33,22,11,66,2,3);
  List<int> l12(5,11,66,111,33,55);
  List<int> l13;

  ltemp1 = List<int>(5,2,3,1,2,3);
  TEST("l9 = l7 + l8", (l9==ltemp1), TRUE);

  ltemp1 = List<int>(5,2,3,4,5,6);
  TEST_RUN("l7 += l10", l7 += l10, (l7==ltemp1), TRUE);

  ltemp1 = List<int>(4,55,33,11,66);
  TEST_RUN("l11 &= l12", l11 &= l12, (l11==ltemp1), TRUE);

  ltemp1 = List<int>(5,111,55,33,11,66);
  TEST_RUN("l11 |= l12", l11 |= l12, (l11==ltemp1), TRUE);

  TEST_RUN("l11 -= l12", ltemp1.clear(); l11 -= l12, (l11==ltemp1), TRUE);

  ltemp1 = List<int>(5,11,66,111,33,55);
  TEST_RUN("l11 ^= l12", l11 ^= l12, (l11==ltemp1), TRUE);

  l11 = List<int>(12,1,55,3,88,77,44,33,22,11,66,2,3);
  l12 = List<int>(5,11,66,111,33,55);

  ltemp1 = List<int>(4,55,33,11,66);
  TEST_RUN("l13 = l11 & l12", l13 = l11 & l12, (l13==ltemp1), TRUE);

  ltemp1 = List<int>(13,111,1,55,3,88,77,44,33,22,11,66,2,3);
  TEST_RUN("l13 = l11 | l12", l13 = l11 | l12, (l13==ltemp1), TRUE);

  ltemp1 = List<int>(8,1,3,88,77,44,22,2,3);
  TEST_RUN("l13 = l11 - l12", l13 = l11 - l12, (l13==ltemp1), TRUE);

  ltemp1 = List<int>(9,1,3,88,77,44,22,2,3,111);
  TEST_RUN("l13 = l11 ^ l12", l13 = l11 ^ l12, (l13==ltemp1), TRUE);
}

void list_int_set_test() {

  list_int_set_test1();
  list_int_set_test2();
  list_int_set_test3();
}



