//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: LGO 05/22/89 -- Initial design and implementation
// Updated: MBN 09/16/89 -- Added conditional exception handling
// Updated: MJF 06/30/90 -- Added base class name to constructor initializer
//

#include <cool/Package.h>

// Package -- Constructor to initialize a package of constant symbols
// Input:     Number of package entries, pointer to initialize function
// Output:    None

Package::Package (unsigned long n, Package_Initializer init)
#ifdef __cplusplus
 : Hash_Table<char*, Symbol*>(n)
#else
 : (n)
#endif
{
  (*init)(this);				
}
