//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: LGO 11/28/89 -- Initial design and implementation
// Updated: MJF 03/12/90 -- Added group names to RAISE
//

#include <cool/Generic.h>

// text_package_put -- Attach a translation to a text_package entry
void
text_package_put(text_package_entry& entry, Symbol* prop, const char* value) {
  text_package_entry* addition = new text_package_entry;
  addition->value = value;
  addition->language = prop;
  addition->next = NULL;
  for(text_package_entry* next=&entry; next->next!=NULL; next=next->next);
  next->next = addition;
}

// set_text_language -- set a new language for a package
// Input:	Optional Symbol which specifies the new language
//		The default is the origional language of the code
//		(hacker English).
//
//		Optional pointer to the text_package.  The default is
//		&ERR_MSG_entries[0]
//
// Output:	When a package entry doesn't have a translation for
//		the specified language, a warning exception is raised.
//		The number of these exceptions is returned.
//
int set_text_language(Symbol* language, text_package_entry* package)
{
  int i;
  int nerrors = 0;
  if (package == NULL)				// Default package is ERR_MSG
    package = &ERR_MSG_entries[0];
  for(i=0; package[i].language != NULL; i++) {
    text_package_entry* next;
    if (language == NULL)			// Default language is initial
      package[i].value = (CONST char*) package[i].language;
    else {
      for(next = package[i].next; next != NULL; next = next->next) {
	if(next->language == language) {
	  package[i].value = next->value;
	  goto found;
	}
      }
      nerrors++;
      RAISE (Warning, SYM(Text_Package), SYM(No_Translation),
	    "set_text_language(): No %s translation for \"%s\"",
	    language->name(), package[i].value);
    }
  found: ;
  }
  return nerrors;
}

