//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created:  MBN 08/31/89 -- Initial design and implementation
// Modified: LGO 09/19/89 -- Split into seperate files
//
// The Vector class is publicly derived from  the Generic class  and is used to
// implement non-type specific functionality for the parameterized Vector<Type>
// class. In this manner, code common to all instances of  the Vector class can
// be shared to reduce code  replication. The Vector<Type>  class is dynamic in
// the sense that an object can grow dynamically if necessary.  The growth size
// is determined by the  value  of a  static  allocation size variable  for the
// class.  However, fixed length vectors  are also  supported by  setting  this
// variable  to INVALID.   The Vector class  implements the notion of a current
// position. This is useful  for iterating through  the  elements of a  vector.
// The current position is maintained in an integer and  is set or reset by all
// methods  affecting elements in the  Vector class. Methods to reset,  move to
// the next and previous, find,  and get the value at  the current position are
// provided.
//

#include <cool/Base_Vector.h>			// Include the class header
#include <cool/Generic.h>				// Include the class header

// The following is required because class Vector
// is declared before all of generic is included:
IMPLEMENT_GENERIC(Vector)

#ifdef __cplusplus
float Vector::growth_ratio = 0.0;		// Initialize growth ratio
#endif
