//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created:  MBN 08/31/89 -- Initial design and implementation
// Modified: LGO 09/19/89 -- Split into seperate files
// Updated:  MBN 10/11/89 -- Changed "current_position" to "curpos"
//

#include <cool/Base_Vector.h>			// Include the class header
#include <cool/Generic.h>				// Include the class header


// Vector (Vector&) -- Constructor for reference to another vector object
// Input:              Vector reference
// Output:             None

Vector::Vector (const Vector& v) {
#ifndef __cplusplus
  if (this->growth_ratio == 0.0)		// If not initialized
    this->growth_ratio = 0.0;			// Initialize growth ratio
#endif
  alloc_size = v.alloc_size;			// Set the default size 
  if (alloc_size == INVALID)			// If invalid allocation size
    alloc_size = MEM_BLK_SZ;			// Set default size
  this->size = v.size;				// Copy element capacity
  this->number_elements = v.number_elements;	// Same number of elements
  this->curpos = INVALID;			// Invalidate current position
}
