//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 08/31/89 -- Initial design and implementation
// Updated: LGO 09/19/89 -- Split into seperate files
// Updated: MBN 10/11/89 -- Changed "current_position" to "curpos"
// Updated: MJF 03/12/90 -- Added group names to RAISE
//

#include <cool/Base_Vector.h>			// Include the class header
#include <cool/Generic.h>			// Include the class header

// Vector& operator= () -- Overload the assignment operator
// Input:                  Reference to Vector object
// Output:                 Reference to copied Vector object

Vector& Vector::operator= (const Vector& v) {
  this->number_elements = v.number_elements;	// Copy number of elements
  this->growth_ratio = v.growth_ratio;		// Copy the growth ratio
  this->curpos = INVALID;			// Invalidate current position
  return *this;					// Return Vector reference
}

// assign_error -- Raise exception for Vector<Type>::operator=()
// Input:          Type string
// Output:         None

void Vector::assign_error (const char* Type) CONST {
  RAISE (Error, SYM(Vector), SYM(Static_Size),
	 "Vector<%s>::operator=(): Static-size vector", Type);
}
