//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/Date_Time.h>			// Include COOL Date/Time header
#include <cool/Package.h>			// Include COOL Package header

symbol_package (MY_SYM, "my_sym.p");		// Create symbol package

DEF_MY_SYM (sym1, String, new String("Greetings!")); // Compile time value/property
DEF_MY_SYM_PROPERTY (sym1, MY_SYM (Property example), Symbol, MY_SYM (String));

int main (void) {
  Symbol *s1 = MY_SYM (sym1);			    // Lookup first symbol
  cout << "First symbol is " << s1->name() << "\n"; // Output symbol name
  cout << "Also available via MY_SYM(sym1): " << MY_SYM(sym1)->name () << "\n";
  cout << s1 << "\n";				    // Output value/property list
  s1->set (new String ("Goodbye!"));		    // Add new value
  cout << "sym1 value is now " << s1->value () << "\n"; // Output value of first symbol
  Date_Time d1 (US_CENTRAL, UNITED_STATES);	    // Create date/time object
  d1.set_local_time ();				    // Set to current date/time
  Symbol* s2 = MY_SYM (sym2);			    // Create new symbol object
  cout << "Second symbol is " << s2->name() << "\n";// Output symbol name
  cout << "Also available via MY_SYM(sym2): " << MY_SYM(sym2)->name () << "\n";
  s2->put (MY_SYM (Creation Time), &d1);	    // Add property
  cout << s2 << "\n";				    // Output runtime symbol
  return 0;					    // Return valid completion code
}
