/*


 Copyright (C) 1990 Texas Instruments Incorporated.

 Permission is granted to any individual or institution to use, copy, modify,
 and distribute this software, provided that this complete copyright and
 permission notice is maintained, intact, in all copies and supporting
 documentation.

 Texas Instruments Incorporated provides this software "as is" without
 express or implied warranty.


 *
 * Edit history
 * Created: LGO 30-Mar-89 -- Initial design and implementation.
 * 
 * The PARMTYPE defmacro
 *
 * CPP defmacro for constructing parameterized types
 * The input looks like  name<arg1, arg2, argn>
 * The output looks like name_arg1_arg2_argn
 * An asterisk in an arg is converted to a capital P.
 *
 * 02-Mar-91 MJF        Added fix to remove all underscores at end of name
 *                      found by grahamd@otc.otca.oz.au
 *
 */

#include "defmacio.h"

#define BSIZE 512
 
/*
 * Convert a paramertized name string into its c++ name
 */
int parmstring(parms)
  char* parms;
{
  char* inp = parms;
  char* outp = parms;
  int bracket_level = 0;
  char c;
  for(; (c = *inp) != EOS; inp++) {
    switch (c) {
    case '<': bracket_level++; *outp++ = '_'; break;
    case '>': bracket_level--; *outp++ = '_'; break;
    case '*': *outp++ = 'P'; break;	  /* Convert * to P */
    case '.': *outp++ = 'x'; break;	  /* Convert . to x */
    case ',': *outp++ = '_'; break;	  /* Convert , to _ */
    case '_': *outp++ = '_'; break;	  /* _ is _ */
    case '$': *outp++ = '$'; break;	  /* $ is $ */
    default:			/* Throw out anything else not alpha-numeric */
      if(isalnum(c)) *outp++ = c;
    }
  }
  while(*(outp-1) == '_') outp--;		  /* Trim trailing _'s */
  *outp = EOS;
  if(bracket_level == 0) {
    return 0;
  } else {
    fprintf(stderr, "parmtype: Unexpeced EOF for %s\n", parms);
    return 1;
  }
}

parmtype(argc, argv)
     int argc;
     char* argv[];
{
  char c;
  char out[BSIZE];
  char* outp = out;

  while((c=getchar()) != EOF) *outp++ = c;
  *outp = EOS;
  if(parmstring(out) != 0) 
    return 1;
  puts(out);
  return (0);
}
