.nr PS 10
.nr VS 12
.nr PD .7v
.nr LL 6.5i
.TL
 ** DRAFT **
 Symbols and Packages in C++
 ** DRAFT **
.AU
Mary Fontana
LaMott Oren
Dane Meyer
.AI
Texas Instruments Incorporated
Computer Science Center
Dallas, TX
.AU
Martin Neath
.AI
Texas Instruments Incorporated
Information Technology Group
Austin, TX
.ND 
.AB
The Texas Instruments C++ Object-Oriented Library (COOL) is a collection of
classes, templates and macros for use by C++ programmers writing complex
applications.  Symbolic computing in COOL is one component of this library
that substantially improves the development capabilities available to the
programmer by providing symbol and package manipulation and runtime type
checking and type query.  This paper will focus on the implementation and
sample usage of symbols and packages.

** Note that currently this paper describes the implementation of symbols
and packages in a very technical reference format. We are in the process
of modifying it to place more emphasis on why a programmer would want to
use this capability in object oriented C++ programs.  This will include
example situations, usage, and comparison with other alternatives, in
addition to the current reference material. **
.AE
.NH 1
Introduction
.LP
The Texas Instruments C++ Object-Oriented Library (COOL) is a collection of
classes, templates and macros for use by C++ programmers writing complex
applications.
An important feature of this library is the symbolic
computing capability which provides symbol and package manipulation and
runtime type checking and query.
This paper will describe the symbol and package mechanism.
Symbols and packages make extensive use of the COOL macro facility.  This
macro facility, implemented as an extension to the ANSI C preprocessor, 
provides the ability to define powerful extensions to the C++ language in
an unobtrusive way.  For a full discussion of this macro facility, 
see the paper
.I
A Portable Implementation of Parameterized Templates Using A Sophisticated C++
Macro Facility, 
.R
[5].
For details on the runtime type checking capability in COOL, 
see the paper,
.I
A Runtime Type Checking and Query Mechanism for C++
.R
[4].
For an overview of the COOL class library, see the paper,
.I
COOL - A C++ Object-Oriented Library 
.R
[1].
For complete details, see the reference document,
.I
COOL User's Guide 
.R
[6].

The ability to manipulate symbols and packages is 
is found in Common LISP [7]
but is unavailable in the C++ language.
COOL supports efficient symbolic computing by providing symbolic constants and
run-time symbol objects.  Dynamic user-defined packages support symbol
storage, query and modification at run-time and are available via an
easy-to-use programming interface. 

.NH 1
Symbol and Package
.LP
The \fBSymbol\fR class implements the notion of a symbol object that has a
name, value and property list.  Symbols are interned into a package, which is
merely a mechanism for establishing separate name spaces for groups of symbols.
The \fBPackage\fR class is implemented as a hash table of symbol objects and
includes public member functions for adding, retrieving, updating and removing
symbols.  It also provides "Emacs" style completion, "InterLisp" style spelling
correction, and "apropos" (which finds a symbol whose name contains a specified
substring) on the symbol names.  Because symbols are unique within their own
package, they can be used as dynamic enumeration types as well as run-time
variables defined at run-time.

In addition to dynamic, run-time symbols, the COOL \fBDEFPACKAGE\fR mechanism
makes it possible to define constant pointers to symbols at compile-time.
These compile-time symbols are interned in their package at application startup
time.  For example, the \fBSYM\fR package and \fBERR_MSG\fR package in COOL are
initialized in this manner.  This mechanism allows for highly efficient symbol
and package manipulation and is used extensively by COOL to implement run-time
type checking and query capabilities.
.NH 1
DEFPACKAGE
.LP
\fBDEFPACKAGE\fR allows declaration of a package which contains only constant
symbols with associated default values and properties.  This is useful when the
application needs to set up a table of symbols where all information is known
at compile time.  This saves the run-time overhead associated with the
\fBPackage\fR class.  An application declares a new type of constant package
with the following statement:

.DS I
\fBDEFPACKAGE \fIname\fR <\fIfile\fR> \fIoptions\fR
.DE
where \fIname\fR is the name of the package to create, \fIfile\fR is the name
of the file where symbol definitions in the package are kept, and \fIoptions\fR
are optional control parameters separated by commas.  The list of options
available is shown below.
.DS I
\fBcount = \fIidentifier\fR
.RS
Defines \fIidentifier\fR as a symbolic name constant.
If specified, the package file will include "\fB#define \fIidentifier
\fInum\fR", where \fInum\fR is the total number of symbols defined in the
package at compile-time.  The default is to not define this constant.
.RE
\fBuse_first = \fInum\fR
.RS
When \fInum\fR is non-zero, the first value defined
for a symbol is the one used.
Redefinition attempts are ignored. This option is used by \fBONCE_ONLY\fR.
The default is 0.
.RE
\fBstart = \fInum\fR
.RS
Use \fInum\fR as the starting (first) index of symbols in the package.
The default is 0.
.RE
\fBincrement = \fInum\fR
.RS
Increment each symbol index in package by \fInum\fR. The default is 1.
.RE
\fBtemplate = \fInum\fR
.RS
Inclusive-or each symbol index in package with \fInum\fR.  The default is 0.
.RE
\fBmax = \fInum\fI
.RS
When \fInum\fR is non-zero, generate an error when the number of constant 
symbols in the package exceeds \fInum\fR.  The default is 0.
.RE
\fBnospace = \fInum\fR
.RS
When \fInum\fR is non-zero, remove all whitespace from symbol names.
The default is 0.
.RE
\fBcase = \fBupper\fR | \fBlower\fR | \fBcap\fR | \fBsensitive\fR
.RS
\fBupper\fR and \fBlower\fR converts all symbol name alphabetical characters to
uppercase and lowercase, respectively.
\fBcap\fR capitalizes the first letter of each symbol
name, and convert remaining letters to lowercase.  \fBsensitive\fR preserves
the case of the symbol name and is the default.
.RE
.DE
\fBDEFPACKAGE\fR builds an internal package table entry based on its
parameters.  The package entry gets further updated with symbols specified
throughout the program with \fBDEFPACKAGE_SYMBOL\fR.  
.NH 1
DEFPACKAGE_SYMBOL
.LP
\fBDEFPACKAGE_SYMBOL\fR adds, updates and retrieves the values and properties
of constant symbols.  It is implemented as a COOL \fBdefmacro\fR [2] and has the
following syntax:
.DS I
\fBDEFPACKAGE_SYMBOL (\fIpackage\fB, \fIsymbol\fB,\fR [\fItype\fR]\fB,\fR [\fIvalue\fR]\fB,\fR [\fIproperty\fR]\fB,\fR [\fIexpander\fR]\fB)\fR
.DE
where \fIpackage\fR is the name of the package that the symbol belongs to,
\fIsymbol\fR is the name of the symbol being added or accessed, \fItype\fR is
the optional data type of the value, \fIvalue\fR is the optional value of the
symbol or property, \fIproperty\fR is the optional name of the property, and
\fIexpander\fR is the name of an optional user-defined macro which is to be
invoked in place of the default expansion of \fBDEFPACKAGE_SYMBOL\fR.  The
\fIexpander\fR will be called by \fBDEFPACKAGE_SYMBOL\fR with the following
arguments:
.DS I
\fIexpander (\fIindex\fB, \fIsymbol\fB, \fItype\fB, \fIvalue\fB)\fR
.DE
where \fIindex\fR is the index number of symbol in the package, and 
\fIexpander\fR, \fIsymbol\fR, \fItype\fR
and \fIvalue\fR are the arguments supplied to \fBDEFPACKAGE_SYMBOL\fR.

\fBDEFPACKAGE_SYMBOL\fR causes a macro definition unique to the specified
package to be written to the package definition file.  The
<package>_DEFINITIONS macro expands to macro calls which define the symbols,
set the symbol values, and set the symbol properties.  Each
\fBDEFPACKAGE_SYMBOL\fR would generate a define_macro, value_macro or
property_macro in the package definition file.
.DS I
MACRO package##_DEFINITIONS (define_macro value_macro property_macro) {
	define_macro (index, name)
	value_macro (index, type, value)
	property_macro (index, property, type, value)
	...
}
.DE

For example,
the \fBSYM\fR package is defined with \fBDEFPACKAGE\fR.
It's symbols will be stored in the file, \fBsym_package.p\fR.
The named
constant, \fBSYM_count\fR, will contain the total number of symbols in the
\fBSYM\fR package.  The case of each symbol is preserved.  A symbol's value may
be updated.  Zero is the starting index for the package.
No increment or inclusive-or is done on the symbol's index.
Finally, there is no limit on the maximum number of symbols allowed in this
package.
.DS I
DEFPACKAGE SYM <sym_package.p> count=SYM_count, case=sensitive, use_first=0,
                              start=0, increment=1, template=0, max=0
.DE
Shown below,
\fBSYM\fR is a macro defined to add a symbol name to the \fBSYM\fR package.
\fBexpand_sym\fR is the expander macro for \fRSYM\fR which  replaces
occurrences of \fBSYM\fR with the symbol table entry of the symbol.
\fBSYM_symbols\fR is an array of pointers to Symbol objects and is 
initialized with the symbol names found in the file \fBsym_package.p\fR.
.DS I
Symbol* SYM_symbols [SYM_count];

#define expand_sym (index, symbol, type, value)	 (SYM_symbols[index])

MACRO SYM (symbol) {
  DEFPACKAGE_SYMBOL(SYM, #symbol,,,, expand_sym)
}
.DE
COOL supports run-time type query by using the \fBSYM\fR package to store all
class name which inherit from the \fBGeneric\fR class.  The \fBclass defmacro\fR
in COOL uses the \fBSYM\fR macro to add a derived Generic class to the \fBSYM\fR
package.  An application uses \fBSYM\fR to access a symbol in the SYM
package.
.DS I
Generic* obj;
obj->is_type_of (SYM(Error));
.DE 
expands to:
.DS I
Generic* obj;
obj->is_type_of (SYM_symbols[1]);
.DE

Each \fBDEFPACKAGE_SYMBOL\fR adds or updates a symbol table entry and
optionally sets either the symbol's value or property.  After the symbol table
is built, the package is written into the package definition file specified in
\fBDEFPACKAGE\fR.  How this package file of symbols is loaded into
the application depends on the type of package being created.

Several macros in COOL simplify the process of creating, accessing and
initializing a package at run-time.  \fBENUMERATION_PACKAGE\fR,
\fBSYMBOL_PACKAGE\fR, \fBTEXT_PACKAGE\fR and \fBONCE_ONLY\fR create a specific
type of package, define macros which are used to add symbols to the package and
update their values and properties, and define the run-time initialization of
the package.

.B
Examples
.R

(1) Assuming the SYM package was created with:
.DS I
DEFPACKAGE SYM <SYM> name=sym_package.p, count=SYM_count, case=sensitive,
                                        start=0, increment=1, template=0, max=0
.DE
and the macro SYM is used to add a symbol to the SYM package:
.DS I
#define expand_SYM (index, symbol, type, value)	 (SYM_symbols[index])

MACRO SYM (symbol) {
	DEFPACKAGE_SYMBOL(name, #symbol,,,, expand_SYM)
}
.DE
In an application program:
.DS I
SYM(Exception);  SYM(Warning);  SYM(Error);  ...  SYM(Random);
.DE
would expand to:
.DS I
SYM_symbols[0];  SYM_symbols[1];  SYM_symbols[2]; ...  SYM_symbols[35];
.DE
and the following  would be included (by the COOL preprocessor) in
the sym_package.p file for the SYM package:
.DS I
#define SYM_count 36

MACRO SYM_DEFINITIONS (define_macro, value_macro, property_macro) {
	define_macro  (0, "Exception")
	define_macro  (1, "Warning")
	define_macro  (2, "Error")
	...
	define_macro  (35, "Random")
}
.DE
In COOL, the SYM package would be initialized with the symbols found in the
sym_package.p file by using the implement_symbol_package macro in the
application program.  implement_symbol_package uses SYM_DEFINITIONS to create
an instance of Package for SYM.
.DS I
implement_symbol_package(SYM, "sym_package.p")
.DE

(2)  Assuming the Once_Only package was created with:
.DS I
DEFPACKAGE Once_Only <Once_Only> name=once_only.p, count=, case=sensitive, 
                                                      start=0, increment=1, template=0, max=0
.DE
the following shows what would be included in the once_only.p file for
the Once_Only package:
.DS I
MACRO Once_Only_DEFINITIONS(define_macro, value_macro, property_macro) {
	define_macro  (0, String_Support)
	value_macro   (0, char*, "vtbl.C")
	...
	define_macro  (22, List_Support)
	value_macro   (22, char*, "Base_List.C")
	...
}
.DE
(3)  The following shows how the ENUMERATION_PACKAGE macro is implemented
using DEFPACKAGE and DEFPACKAGE_SYMBOL:
.DS I
MACRO enumeration_package (name, file, REST: options) {
	DEFPACKAGE name file options
	#define expand_##name (index, symbol, type, value)   index
	#define name (symbol)   DEFPACKAGE_SYMBOL (name, symbol,,,, expand_##name)
}
.DE

.NH 1
ENUMERATION_PACKAGE 
.LP 
\fBENUMERATION_PACKAGE\fR is a simple interface to the \fBDEFPACKAGE\fR
facility for creating and accessing a package of constant, compile-time
symbols.  Enumeration symbols have no value.  When a symbol is referenced, its
index is returned.  Symbols in an enumeration package can be used anywhere a
standard \fBenum\fR can be used.  Enumeration symbols are easier to add then
\fBenums\fR since they are collected throughout the application source base
and maintained in a separate file.

\fBENUMERATION_PACKAGE\fR is a COOL \fBMACRO\fR [2] 
and has the following syntax:
.DS I
\fBENUMERATION_PACKAGE (\fIname\fB, \fIfile\fB, REST: \fIoptions\fB)\fR
.DE
where \fIname\fR, \fIfile\fR and \fIoptions\fR are parameters that are passed
on to \fBDEFPACKAGE\fR and \fBDEFPACKAGE_SYMBOL\fR.
The macro \fIname\fR(\fIsymbol\fR) is automatically defined to
add \fIsymbol\fR to the \fIname\fR package if it does not
exist and return the index of \fIsymbol\fR in \fIname\fR package.

.B Example

In the example below, the \fBFONT\fR package is created with
\fBENUMERATION_PACKAGE\fR.  \fBfg_13\fR, \fBfg_25\fR and \fBvg_13\fR are
symbols in this package.  \fBFONT(fg_13)\fR, \fBFONT(fg_25)\fR, and
\fBFONT(vg_13)\fR expand to 1, 15, 22, respectively and are the 1st, 15th and
22nd element in the \fBFONT\fR package, respectively.
.DS I
ENUMERATION_PACKAGE (FONT, "font_package.h");

if (f == FONT(fg_13) || f == FONT(fr_25)) do_fixed_width_font();
else if (f == FONT(vg_13)) do_variable_width_font();
.DE
expands to:
.DS I
if (f == 1 || f == 15) do_fixed_width_font();
else if (f == 22) do_variable_width_font();
.DE

.NH 1
TEXT_PACKAGE
.LP
\fBTEXT_PACKAGE\fR is a simple interface to the \fBDEFPACKAGE\fR facility for
creating and accessing a package containing symbols whose default value is the
same as its symbol name.  For example, all error messages in an application
could be implemented as text symbols and the symbol definition file for this
text package would then contain a summary of all the messages.  The message
text can be substituted with another version (perhaps in another language) at
run-time. The COOL error message facility [3] is implemented in this manner.
\fBTEXT_PACKAGE\fR is implemented with \fBMACRO\fR 
and has the following syntax:
.DS I
\fBTEXT_PACKAGE (\fIname\fB, \fIfile\fB, REST: \fIoptions\fB)\fR
.DE
where \fIname\fR, \fIfile\fR and \fIoptions\fR are parameters that are passed
on to \fBDEFPACKAGE\fR and \fBDEFPACKAGE_SYMBOL\fR.  The macro
\fIname\fR(\fIsymbol\fR) is defined to add and retrieve \fIsymbol\fR from the
\fIname\fR package.  If \fIsymbol\fR has not already been added to the package,
it is added and the \fBchar*\fR value is returned.  If \fIsymbol\fR is already
present in the package, the existing \fBchar*\fR value is returned.

.B Example

In the following example, after creating the \fBERR_MSG\fR package with
\fBTEXT_PACKAGE\fR, the ERR_MSG macro is used to add and retrieve error message
symbols.  ERR_MSG expands to the current translation of the error message in
the \fBERR_MSG_entries\fR table.  This table is initialized at run-time with
the compile-time error message strings found in the \fBerr_package.p\fR file.
.DS I
TEXT_PACKAGE (ERR_MSG, "err_package.p");
ERR_MSG("String::resize(): Invalid size %d");
.DE
expands to:
.DS I
ERR_MSG_entries[37].value;
.DE
and is the \fB37\fRth symbol and contains the default value of
\fB"String::resize(): Invalid size %d"\fR.
.NH 1
SYMBOL_PACKAGE
.LP
\fBSYMBOL_PACKAGE\fR is a simple interface to the \fBDEFPACKAGE\fR facility for
creating and accessing a package which contains symbols whose values can be
assigned at run-time.  Entries in a symbol package are pointers to \fBSymbol\fR
objects.  Symbols known at compile time are interned in their package at
application startup time and additional symbols are added at run-time.  Symbols
may have a value and a set of properties.  If not specified, the value and
properties are non-existent, that is, no space other than storage for a
\fBNULL\fR pointer is allocated for them in a table.  \fBSYMBOL_PACKAGE\fR is
a COOL \fBMACRO\fR [2]
and has the following syntax:
.DS I
\fBSYMBOL_PACKAGE (\fIname\fB, \fIfile\fB, REST: \fIoptions\fB)\fR
.DE
where \fIname\fR, \fIfile\fR and \fIoptions\fR are parameters that are passed
on to \fBDEFPACKAGE\fR and \fBDEFPACKAGE_SYMBOL\fR.  \fBSYMBOL_PACKAGE\fR
creates a package and defines three macros for use in adding, updating, and
retrieving symbols in this package.  The macro \fIname(symbol)\fR adds or
retrieves \fIsymbol\fR from the \fIname\fR package.  The macro
\fBDEF_\fIname\fR adds or updates the value of a symbol in the \fIname\fR
package.  The macro \fBDEF_\fIname\fB_PROPERTY\fR adds or updates a property of
a symbol in the \fIname\fR package.

.B Example

The \fBSYM\fR package could be created using \fBSYMBOL_PACKAGE\fR:
.DS I
SYMBOL_PACKAGE (SYM, "sym_package.p")
.DE
and the following macros for accessing the \fBSYM\fR package
would be defined:

.RS
\fBSYM (\fIname\fB)\fR
.RS
Adds the specified symbol \fIname\fR to the \fBSYM\fR package, if not already
defined.  Returns a pointer to a \fBSymbol\fR object.
For example, 
\fBSYM(foo)\fR adds the symbol name, \fBfoo\fR to the \fBSYM\fR package and
expands to \fB&SYM_symbols[37]\fR.
.RE

\fBDEF_SYM (\fIname\fB, \fItype\fB, \fIvalue\fB)\fR
.RS
Sets the specified symbol \fIname\fR in the \fBSYM\fR package
with the specified \fIvalue\fR and \fItype\fR.
For example, 
\fBDEF_SYM (foo, String, String("Greetings!"));\fR
sets the  value of symbol \fBfoo\fR to the string
\fB"Greetings!"\fR.
.RE

\fBDEF_SYM_PROPERTY (\fIname\fB, \fIproperty\fB, \fItype\fB, \fIvalue\fB)\fR
.RS
Sets the named \fIproperty\fR of the symbol \fIname\fR in the \fBSYM\fR package
with the specified \fItype\fR and \fIvalue\fR.
For example, \fBDEF_SYM_PROPERTY (foo, value-type, Symbol, SYM (String));\fR
sets the \fBvalue-type\fR property of symbol \fBfoo\fR
to the symbol \fBString\fB.
.RE
.RE
.NH 1
ONCE_ONLY
.LP
\fBONCE_ONLY\fR provides a simple interface to the \fBDEFPACKAGE\fR facility to
allow an application to control the processing of a section of code. This is
useful in an application where a function or table is referenced in several
source files and needs to be defined the first time it is referenced.
\fBONCE_ONLY\fR is a COOL \fBMACRO\fR [2]
and has the following syntax:
.DS I
\fBONCE_ONLY (\fIsymbol\fB) { \fIbody\fB }\fR
.DE
where \fIsymbol\fR is the name of a symbol and \fIbody\fR is the body of code
to insert in the source only once.  \fIsymbol\fR is used to ensure that
\fIbody\fR is compiled only once.  \fIsymbol\fR is added to the \fBONCE_ONLY\fR
package and its initial value is the file name where \fIsymbol\fR was first
defined.  When \fIsymbol\fR is encountered and its current value is the same as
the current file, then the body of code is compiled.  If \fIsymbol\fR is found
in a different file, then the code is not inserted into the source stream.

.B Example

The \fBAUTO_DECLARE\fR macro defined below insures that \fBIMPLEMENT\fR is
called only once in an application using a parameterized type.  It would be
used instead of \fBDECLARE\fR and \fBIMPLEMENT\fR and would be included in
every source file that references the parameterized type.
.DS I
MACRO AUTO_DECLARE(class, type) {
    DECLARE class<type>;
    ONCE_ONLY (Implement_##class_##type) {
        IMPLEMENT class<type>;
    }
}

AUTO_DECLARE (List, int);
List<int> list1;
.DE
.NH 1
Status of COOL
.LP
Texas Instruments has been using the symbolic computing capability in COOL
for the last year.  Applications have utilized COOL symbols, packages, and
run-time type checking and type query of \fBGeneric\fR-derived class objects.
In addition, the COOL exception handling facility [3] takes advantage
of the run-time type checking of exception objects.

COOL is currently up and running on a Sun SPARCstation 1 (TM) running 
SunOS (TM) 4.x,
.FS
SunOS and SPARCstation 1 are trademarks of Sun Microsystems, Inc.
.FE
a TI System 1500 running TI System V,
a PS/2 model 70 running SCO XENIX\(rg
.FS
XENIX is a registered trademark of Microsoft Corporation.
.FE
2.3, a PS/2 (TM)
.FS
PS/2 is a trademark of International Business Machines Corporation.
.FE
model 70 running OS/2 1.1, and
a MIPS running RISC/os 4.0. The SPARC and MIPS ports utilize the AT&T C++
translator (cfront) version 2.0 and the XENIX and OS/2 ports utilize the
Glockenspiel translator with the Microsoft C compiler.
.NH 1
References
.IP [1]
Mary Fontana, Martin Neath and Lamott Oren,
.I
COOL - A C++ Object-Oriented Library,
.R
Information Technology Group, Austin, TX, Internal Original Issue January 1990.
.IP [2]
Mary Fontana, Martin Neath and Lamott Oren,
.I
A Portable Implementation of Parameterized Templates Using A Sophisticated C++
Macro Facility, 
.R
Information Technology Group, Austin, TX, Internal Original Issue January 1990.
.IP [3]
Mary Fontana, Martin Neath and Lamott Oren,
.I
A Portable Exception Handling Mechanism for C++,
.R
Information Technology Group, Austin, TX, Internal Original Issue January 1990.
.IP [4]
Mary Fontana, Martin Neath and Lamott Oren,
.I
A Runtime Type Checking and Query Mechanism for C++,
.R
Information Technology Group, Austin, TX, Internal Original Issue January 1990.
.IP [5]
Mary Fontana, Martin Neath, and Lamott Oren,
.I
A Portable Implementation of Parameterized Templates Using A Sophisticated C++
Macro Facility, 
.R
Information Technology Group, Austin, TX, Internal Original Issue January 1990.
.IP [6]
Texas Instruments Incorporated,
.I
COOL User's Guide,
.R
Information Technology Group, Austin, TX, Internal Original Issue January 1990.
.IP [7]
Guy L. Steele Jr,
.I
Common LISP: The Language,
.R
Second Edition, 1990.

