//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
//
// Created: MBN 04/04/89 -- Initial design and implementation
// Updated: LGO 01/05/90 -- Split into seperate files
// Updated: DLS 03/22/91 -- New lite version
//

#include <cool/char.h>		// Include char* specification header file

// reverse -- Reverse the order of the characters in char*
// Input:     char* 
// Output:    char* with character order reversed

void reverse (char* c) {		// Reverse the order of characters
  int length = strlen (c);		// Number of characters in string
  char temp;

  for (int i = 0, j = length-1;		// Counting from front and rear
       i < length / 2; i++, j--) {	// until we reach the middle
    temp = c[i];			// Save front character
    c[i] = c[j];			// Switch with rear character
    c[j] = temp;			// Copy new rear character
  }
}
