/*


 Copyright (C) 1990 Texas Instruments Incorporated.

 Permission is granted to any individual or institution to use, copy, modify,
 and distribute this software, provided that this complete copyright and
 permission notice is maintained, intact, in all copies and supporting
 documentation.

 Texas Instruments Incorporated provides this software "as is" without
 express or implied warranty.


 *
 * Edit history
 * Created: LGO 30-Mar-89 -- Initial design and implementation.
 *
 * GENERATE(arg,things)s{body}
 *
 * where:
 *   "things" is a comma-separated list of arguments
 *   "body"   is expanded once for each thing in "things"
 *   "arg"    is substituted for a "thing" while expanding "body"
 *   "s"      is placed after each "body" expansion, except for the last time.
 *	      useful values of "s" are nothing, a space, or a comma.
 *
 * The result of expanding GENERATE is the result of expanding all the "body"
 * expansions with all newline's compressed out.
 *
 * Example:
 *
 * MACRO ODD(REST: ints)
 * { GENERATE(x, ints),{
 *    #if x&1
 *      x
 *    #endif
 *   }
 * }
 *
 * ODD(1,2,3,4,5,6) // expands to     1,     3,     5
 *
 */

#define MAX_ARGS 512

#include "defmacio.h"
#include "macro.h"

int generate(argc, argv)
     int argc;
     char* argv[];
{
  char c;
  int nargs = 0;
  int i;
  char* subst[1];
  char* value[1];
  char* args[MAX_ARGS];
  char seperator = EOS;
  char* body;
  char* bp;
  scan_next(' ');			  /* Skip macro name */
  c = skip_blanks();
  if(c != '(') {
    fprintf(stderr, "GENERATE: Can't find argument list\n");
    return 1;
  }
  for (;;) {
    if(nargs >= MAX_ARGS) {
      fprintf(stderr, "GENERATE: more than %d arguments\n", MAX_ARGS);
      return 1;
    }
    args[nargs++] = scan_token(",)");
    c = getchar();
    if (c == ')') break;
    if (c == EOF) {
      fprintf(stderr, "GENERATE: unexpected end of file\n");
      return 1;
    }
  }
  c = skip_blanks();
  if (c != '{') {
    seperator = c;
    c = skip_blanks();
  }
  if (c != '{') {
    fprintf(stderr, "GENERATE: Body missing, found %c instead\n", c);
    return 1;
  }
  unget();
  body = scan_next('}');		  /* Grab the macro body */
  while(*body++ != '{');		  /* strip start of body */
  bp = body + strlen(body);		  /* Strip end of body */
  *--bp = EOS;

  bp = work_string->buff;		  /* First parm is subst */
  subst[0] = args[0];
  bp += strlen(subst[0]) + 1;
  for (i=1; i<nargs; i++) {
    value[0] = args[i];
    macro_substitute(body, 1, subst, value);
    free(args[i]);
    if (seperator != EOS && i+1 < nargs) putchar(seperator);
  }
  return 0;
}
