/*


 Copyright (C) 1990 Texas Instruments Incorporated.

 Permission is granted to any individual or institution to use, copy, modify,
 and distribute this software, provided that this complete copyright and
 permission notice is maintained, intact, in all copies and supporting
 documentation.

 Texas Instruments Incorporated provides this software "as is" without
 express or implied warranty.


 *
 * Edit history
 * Created: LGO 30-Mar-89 -- Initial design and implementation.
 *
 * ISSAME defmacro
 *
 * #pragma defmacro ISSAME "member" delimiter=) expanding
 *
 * CPP defmacro for doing symbolic comparisions
 * The input looks like ISSAME(arg1, arg2, ..., argn)
 * The output is "1" when arg1 is the same as one of the other args, else "0".
 *
 */

#include "defmacio.h"

#define BSIZE 512

member(argc, argv)
   int argc;
   char** argv;
{
  char c;
  char macname[BSIZE];
  char* arg1;
  char* arg2;

  if(copytoken(macname) == NULL)	  /* Skip macro name */
    return(1);

  c = skip_blanks();
  if(c != '(') {
    fprintf(stderr, "%s: Can't find argument list\n", macname);
    return 1;
  }

  arg1 = scan_token(",)");
  getchar();
  do {
    arg2 = scan_token(",)");
    if(strcmp(arg1, arg2) == 0) {
      putchar('1');
      goto exit;
    }
    free(arg2);
  } while (getchar() != ')');
  putchar('0');
 exit:
  free(arg1);
  free(arg2);
  return 0;
}
