\  Example program for 6809 simulator. 
\  Convert 32-bits binary number to decimal.

assemble
        $100 org
        jmp -1	

\ Example numbers for conversion
label num1	 -1 , -1 ,       \ should be 4294967295
label num2	 0 , 0 ,         \ should be 0000000000
label num3      32768 , 0 ,    \ should be 2147483648
label num4	$3b9a , $c9ff , \ should be 0999999999
label num5      $3b9a , $ca00 , \ should be 1000000000
label num6	0 , 5501 ,	\ should be 0000005501



label bcdbuf	 5 allot
label temp	 1 allot
label temp2 	 1 allot

\ Convert 4-byte number pointed to by X to 5-byte (10 digit) bcd.
label bin2bcd 
        ldu # bcdbuf
	ldb # 5
        begin 
         clr ,u+		\ Clear the 5-byte bcd buffer.
	 decb
	0= until
        ldb # 4		\ traverse 4 bytes of bin number 
	stb temp
        begin 
	 ldb # 8		\ and 8 bits of each byte. (msb to lsb)
	 stb temp2
         begin
 	  rol 0 ,x		\ Extract next bit from binary number.
	  ldb # 5
          ldu # bcdbuf 5 +
          begin
	   lda ,-u	\ multiply bcd number by 2 and add extracted bit
	   adca 0 ,u	\ into it. 
 	   daa
	   sta 0 ,u
	   decb
	  0= until
	  dec temp2
	 0= until
	 leax 1 ,x
	 dec temp
	0= until
	rts

\ Output character B 
label outch	
        swi2
	rts

\ Print double number (including leading zeros)  pointed to by X. 
\ Number at that location is destroyed by the process.
label prtdec	
	jsr bin2bcd	\ Convert to bcd
        ldx # bcdbuf	\ Traverse 5-byte buffer.
	ldb # 5
	stb temp
        begin 
	 lda ,x+	        
         tfr a, b		
	 lsrb
	 lsrb
	 lsrb
	 lsrb		 \ Extract higher digit from bcd byte.
 	 addb # char 0
	 jsr outch
	 tfr a, b
	 andb # 15	\ Extract lower digit.
	 addb # char 0
	 jsr outch
	 dec temp
	0= until
	ldb # 13		\ output newline.
	jsr outch
	ldb # 10
	jsr outch
	rts

label main	
        lds # $1ff
	ldx # num1
	jsr prtdec
	ldx # num2
	jsr prtdec
	ldx # num3
	jsr prtdec
	ldx # num4
	jsr prtdec
	ldx # num5
	jsr prtdec
	ldx # num6
	jsr prtdec
	sync

main $100 1+ V! \ patch jump address at file start.

endasm
