#
# makefile ---	builds forth online help utilities.
#		EMX version.
#

CC = gcc

CFLAGS = -g -Wall -DEMX
LDFLAGS = -g

CFLAGS = -O2 -fomit-frame-pointer -Wall -DEMX
LDFLAGS = -s

# my GNU-make 3.58 for DOS needs these, probably not installed correctly.
.SUFFIXES:	.o .c
.c.o:	;	$(CC) $(CFLAGS) -c $< -o $@

OBJECTS =	showhelp.o helpidx.o helpsubr.o

all:		showhelp.exe index

helpidx.exe:	helpidx.o helpsubr.o
		$(CC) $(LDFLAGS) helpidx.o helpsubr.o -o helpidx.exe

showhelp.exe:	showhelp.o helpsubr.o
		$(CC) $(LDFLAGS) showhelp.o helpsubr.o -o showhelp.exe

index:		helpidx.exe *.hlp
		helpidx -o index *.hlp

$(OBJECTS):	help.h

clean:	;	rm -f *.o core showhelp.exe helpidx.exe index
new:		clean all
