/*
 * help.h --- declarations for FORTH online help utilities.
 * (duz 13Sep94)
 */

#ifndef __HELP_H
#define __HELP_H

#include <limits.h>

#ifndef PATH_LENGTH		/* suggested by Andrew Houghton */

# ifdef _POSIX_PATH_MAX
#   define PATH_LENGTH _POSIX_PATH_MAX
# else
#   ifdef MAXPATHLEN
#     define PATH_LENGTH MAXPATHLEN
#   else
#     ifdef PATH_MAX
#	define PATH_LENGTH PATH_MAX
#     else
#	define PATH_LENGTH 256
#     endif
#   endif
# endif

#endif


typedef struct head Head;	/* index file header */
typedef struct item Item;	/* record in index file */

struct head
{
  char magic [4];		/* magic number */
  int nfiles;			/* how many help files are gathered */
  int nitems;			/* total items in this index */
};

struct item
{
  char name [32];		/* name of the definition */
  int fidx;			/* index of file, see head */
  fpos_t pos;			/* position in file */
};

extern int optopt;		/* declaration missing in stdlib.h */
				/* on at least FreeBSD and AIX. Why? */
extern char *progname;

void fatal (char *msg, ...);
void sys_error (void);
void file_error (char *fn);
void *xalloc (int n, size_t len);
#define NEW(P,N) (P) = xalloc (N, sizeof *(P))


#endif
