/*
 * helpsubr.c --- subroutines for the FORTH online help utilities.
 * (duz 13Sep94)
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include "help.h"


/*
 * Simple error handling: Report and abort.
 */

char *progname;			/* points in argv [0] */

void
fatal (char *msg, ...)
/*
 * quit with error message, formatting like printf()
 */
{
  char buf [0x400];
  va_list v;

  va_start (v, msg);
  vsprintf (buf, msg, v);
  va_end (v);
  fprintf (stderr, "%s: %s.\n", progname, buf);
  exit (1);
}

void
sys_error (void)
/*
 * quit with an error message from strerror ()
 */
{
  fatal ("%s", strerror (errno));
}

void
file_error (char *fn)
/*
 * like sys_error when a file name is at hand.
 */
{
  fatal ("File %s: %s", strerror (errno));
}

void *
xalloc (int n, size_t len)
/*
 * like calloc() but dies with erro message when failed.
 */
{
  void *p = calloc (n, len);
  if (p == NULL) sys_error ();
  return p;
}
