/*
 * showhelp.c --- access help files using an index created by helpindex
 * (duz 13Sep94)
 */

#define _XOPEN_SOURCE 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "help.h"

static Head head;
static char (*file) [PATH_LENGTH];
static Item *item;


/*
 * Read the index file.
 */

void
read_index (char *fn)
{
  FILE *index = fopen (fn, "rb");
  if (index == NULL)
    file_error (fn);
  if (fread (&head, sizeof head, 1, index) != 1)
    file_error (fn);
  if (strncmp (head.magic, "HELP", 4) != 0)
    fatal ("%s is no help index file", fn);
  NEW (file, head.nfiles);
  if (fread (file, sizeof *file, head.nfiles, index) != head.nfiles)
    file_error (fn);
  NEW (item, head.nitems);
  if (fread (item, sizeof *item, head.nitems, index) != head.nitems)
    file_error (fn);
  fclose (index);
}


/*
 * Access a help string using the index.
 */

static Item *
binary_search (char *name, Item *p, int n)
{
  int l = 0;
  int r = n - 1;

  for (;;)
    {
      int i = (l + r) >> 1;
      int x = strcmp (name, p [i].name);

      if (x == 0)
	return &p [i];
      if (x < 0)
	r = i - 1;
      else
	l = i + 1;
      if (l > r)
	return NULL;
    }
}

static void
print_help (char *name)
{
  Item *p = binary_search (name, item, head.nitems);

  if (p == NULL)
    printf ("No help for %s available.\n", name);
  else
    {
      char *fn = file [p->fidx];
      FILE *f = fopen (fn, "r");
      char line [0x80];
      int empty;

      if (f == NULL)
	file_error (fn);
      if (fseek (f, p->pos, SEEK_SET) != 0)
	file_error (fn);

      fgets (line, sizeof line, f);
      fputs (line + 2, stdout);
      empty = 0;

      for (;;)
	{
	  if (!fgets (line, sizeof line, f))
	    if (ferror (f))
	      file_error (fn);
	    else
	      return;
	  if (line [0] == '\n' || line [0] == '#')
	    if (++empty == 2)
	      return;
	  if (line [0] != '#')
	    fputs (line, stdout);
	}
    }
}


/*
 * Main program, process command line.
 */

static void
usage (void)
{
  fatal ("usage: %s file word [word...]", progname);
}

int
main (int argc, char *argv [])
{
  int i;

  /*
   * get program name for error messages
   */
  progname = strrchr (argv [0], '/');
  if (progname)
    progname++;
  else
    progname = argv [0];
  if (argc < 3)
    usage ();

  /*
   * process
   */
  read_index (argv [1]);
  for (i = 2; i < argc; i++)
    print_help (argv [i]);
  return 0;
}
