Object
	subclass: #ForthDataSpace
	instanceVariableNames: 'dataSpace '
	classVariableNames: ''
	poolDictionaries: ''    !


!ForthDataSpace class methods !
  
cells: numCells
        "Create ForthDataSpace of numCells cells and initialize."
    ^self new dataSpace: (Array new: numCells); yourself! !



!ForthDataSpace methods !

allot:  anInt
        "allot cells of data space kept by each task by post-incrementing global Smalltalk variable.
          Has to work this way so Forth Variable class works."
          Task dataPointer: (Task dataPointer) + anInt.
          ^(Task dataPointer)  - anInt!
   
dataSpace
    ^dataSpace!
  
dataSpace: anArray
    dataSpace := anArray.!
  
fetch: anInt
	" low-level portion of Forth @. ... index checking at Task level"
	^dataSpace at: anInt!

size
        "return size of available data space"
    ^self dataSpace size!
  
store: anObject at: anInt
	" low-level portion of Forth !!. ... index checking at Task level"
	dataSpace at: anInt put: anObject! !
