#include "ge1.h"
/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifdef DLEXICALLESS
int             dlexicalless(A, B)
register AFFIX A,B;
{
  register char  *rc = c, *xs = rc, *ys;
  if (A == B)
    return false;
  else if (((A->r) == nil) && ((A->l) == nil))
    xs = (A->t);
  else {
    sprinta(A);
    *c++ = '\0';
  }
  ys = c;
  if (((B->r) == nil) && ((B->l) == nil))
    ys = B->t;
  else {
    sprinta(B);
    *c++ = '\0';
  }
  c = rc;
  if (rc > cstore_top ) cstore_overflow();
  return lexafxcmp(xs, ys) < 0; 
}
#endif

#ifdef DLEXICALMORE
int             dlexicalmore(A, B)         /* lifted equal */
register AFFIX A, B;
{
  register char  *rc = c, *xs = rc, *ys;
  if (A == B)
    return false;
  else if (((A->r) == nil) && ((A->l) == nil))
    xs = (A->t);
  else {
    sprinta(A);
    *c++ = '\0';
  }
  ys = c;
  if (((B->r) == nil) && ((B->l) == nil))
    ys = B->t;
  else {
    sprinta(B);
    *c++ = '\0';
  }
  c = rc;
  if (rc > cstore_top ) cstore_overflow();
  return lexafxcmp(xs, ys) > 0; 
}
#endif

#ifdef DLEXICALLESSEQUAL
int             dlexicallessequal(A, B)         /* lifted equal */
register AFFIX A, B;
{
  register char  *rc = c, *xs = rc, *ys;
  if (A == B)
    return false;
  else if (((A->r) == nil) && ((A->l) == nil))
    xs = (A->t);
  else {
    sprinta(A);
    *c++ = '\0';
  }
  ys = c;
  if (((B->r) == nil) && ((B->l) == nil))
    ys = B->t;
  else {
    sprinta(B);
    *c++ = '\0';
  }
  c = rc;
  if (rc > cstore_top ) cstore_overflow();
  return lexafxcmp(xs, ys) <= 0; 
}
#endif

#ifdef DLEXICALMOREEQUAL
int             dlexicalmoreequal(A, B)         /* lifted equal */
register AFFIX A, B;
{
  register char  *rc = c, *xs = rc, *ys;
  if (A == B)
    return true;
  else if (((A->r) == nil) && ((A->l) == nil))
    xs = (A->t);
  else {
    sprinta(A);
    *c++ = '\0';
  }
  ys = c;
  if (((B->r) == nil) && ((B->l) == nil))
    ys = B->t;
  else {
    sprinta(B);
    *c++ = '\0';
  }
  c = rc;
  if (rc > cstore_top ) cstore_overflow();
  return lexafxcmp(xs, ys) >= 0; 
}
#endif

#ifdef ULEXICALLESS 
void ulexicalless () 
{ 
   register cont *rq = q;
register AFFIX A_1 = rq->a;
register AFFIX A_0 = (rq -1)->a;
   char *rc = c; 
   if ( dlexicalless (A_0, A_1)) {
      q = rq -3;
      (*(rq -2)->q)(); 
      rq = q +2;
   }
   (rq -1)->a = A_0;
   rq->a = A_1;
   (rq + 1)->q = ulexicalless; 
   q = rq + 1; 
   c = rc;
  if (rc > cstore_top ) cstore_overflow();
}
#endif

#ifdef ULEXICALMORE 
void ulexicalmore () 
{ 
   register cont *rq = q;
register AFFIX A_1 = rq->a;
register AFFIX A_0 = (rq -1)->a;
   char *rc = c; 
   if ( dlexicalmore (A_0, A_1)) {
      q = rq -3;
      (*(rq -2)->q)(); 
      rq = q +2;
   }
   (rq -1)->a = A_0;
   rq->a = A_1;
   (rq + 1)->q = ulexicalmore; 
   q = rq + 1; 
   c = rc;
  if (rc > cstore_top ) cstore_overflow();
}
#endif

#ifdef ULEXICALLESSEQUAL 
void ulexicallessequal () 
{ 
   register cont *rq = q;
register AFFIX A_1 = rq->a;
register AFFIX A_0 = (rq -1)->a;
   char *rc = c; 
   if ( dlexicallessequal (A_0, A_1)) {
      q = rq -3;
      (*(rq -2)->q)(); 
      rq = q +2;
   }
   (rq -1)->a = A_0;
   rq->a = A_1;
   (rq + 1)->q = ulexicallessequal; 
   q = rq + 1; 
   c = rc;
  if (rc > cstore_top ) cstore_overflow();
}
#endif

#ifdef ULEXICALMOREEQUAL 
void ulexicalmoreequal ()
{
   register cont *rq = q;
register AFFIX A_1 = rq->a;
register AFFIX A_0 = (rq -1)->a;
   char *rc = c;
   if ( dlexicalmoreequal (A_0, A_1)) {
      q = rq -3;
      (*(rq -2)->q)();
      rq = q +2;
   }
   (rq -1)->a = A_0;
   rq->a = A_1;
   (rq + 1)->q = ulexicalmoreequal;
   q = rq + 1;
   c = rc;
  if (rc > cstore_top ) cstore_overflow();
}
#endif

