/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ge1.h"
struct char_ptr_list { char *l[32];};
extern struct char_ptr_list groups[];

#ifdef  DTRANSFORMLATTICE
int             dtransformlattice_(A, B,C)         /* lifted tranform */
register AFFIX A, B,C;
{
  char * rc = c;
  int i; 
  int x,y   = (long) B -> t;
  x = atoi(A->t); 
  C ->t = rc;
  C ->r = nil;
  C ->l = nil;
  *rc++ = '{';
  for (i = 0 ; i <32 ; i++)
   if ( ((1 << i) &  y ) != 0)  {
     register char * rr = groups[x].l[i];
     while  ((rr != 0) && (*rr != '\0'))
       *rc++ =  *rr++;
     *rc++ = ',';
     if (rr == NULL) {
         fprintf(stderr, 
            "runtime error in tranform lattice: evaluating undefined affix\n");
             exit(1);
        }
   }
  *(rc-1) = '}';
  *rc++ = '\0';
  c = rc;
  if (rc > cstore_top ) cstore_overflow();
  return true;
}
#endif

#ifdef DTRANSFORMLATTICETERM
int             dtransformlatticeterm_(A, B,C)         /* lifted tranform */
register AFFIX A, B,C;
{
  char * rc = c;
  int i; 
  int x,y;
  x = atoi(A->t); 
  y = atoi(B->t); 
  C ->t = rc;
  C ->r = nil;
  C ->l = nil;
  *rc++ = '{';
  for (i = 0 ; i <32 ; i++)
   if ( ((1 << i) &  y ) != 0)  {
     register char * rr = groups[x].l[i];
     while  ((rr != 0) && (*rr != '\0'))
       *rc++ =  *rr++;
     *rc++ = ',';
     if (rr == NULL) {
         fprintf(stderr, 
            "runtime error in tranform lattice: evaluating undefined affix\n");
             exit(1);
        }
   }
  *(rc-1) = '}';
  *rc++ = '\0';
  c = rc;
  if (rc > cstore_top ) cstore_overflow();
  return true;
}
#endif

#ifdef DEXPLINTERSECT
int dexplintersect_(A,B)
register AFFIX A, B;
{
  
  char *cx   = B -> t;
  long y   = (long) A -> t;
  long x   = atoi(cx); 
  long z = x &y;
 
  if (z == 0) 
    return false;
  A ->t = (char *) z;
  return true;
}
#endif

#ifdef UEXPLINTERSECT
void uexplintersect_(){
   register cont *rq = q;
register AFFIX A_1 = (rq+0)-> a;
register AFFIX A_0 = (rq+-1)-> a;
   char *rc = c; 
   if (dexplintersect_(A_0,A_1))
   { 
      q = rq+-3;
      (*(rq+-2)->q)();
      rq = q+2;
   }
   (rq+-1)->a = A_0;
   (rq+0)->a = A_1;
   (rq+1)-> q = uexplintersect_; 
   q = rq+1; 
   c = rc;
  if (rc > cstore_top ) cstore_overflow();
}
#endif

#ifdef DINTERSECT
int dintersect_(A,B)
register AFFIX A, B;
{
  long x   = (long) A -> t;
  long y   = (long) B -> t;
  long z = x &y;
 
  if (z == 0) 
    return false;
  B ->t = (char *) z;
  return true;
}
#endif

#ifdef UINTERSECT
void uintersect_(){
   register cont *rq = q;
register AFFIX A_1 = (rq+0)-> a;
register AFFIX A_0 = (rq+-1)-> a;
   char *a1 = A_1 ->t,*a0 = A_0 ->t,  *rc = c; 
   if (dintersect_(A_0,A_1))
   { 
      q = rq+-3;
      (*(rq+-2)->q)();
      rq = q+2;
   }
   (rq+-1)->a = A_0;
   (rq+0)->a = A_1;
   (rq+1)-> q = uintersect_; 
   q = rq+1; 
   c = rc;
  if (rc > cstore_top ) cstore_overflow();
   A_1 ->t = a1;
   A_0 ->t = a0;
}
#endif

#ifdef UTRANSFORMLATTICE
void utransformlattice_(){
   register cont *rq = q;
register AFFIX A_2 = (rq+0)-> a;
register AFFIX A_1 = (rq+-1)-> a;
register AFFIX A_0 = (rq+-2)-> a;
   char *rc = c;
   if (dtransformlattice_(A_0,A_1,A_2))
   { 
      q=rq-4;
      (*(rq-3)->q)();
      rq=q+3;
   }
   c = rc;
  if (rc > cstore_top ) cstore_overflow();
   (rq+-2)->a = A_0;
   (rq+-1)->a = A_1;
   (rq+0)->a = A_2;
   (rq+1)-> q = utransformlattice_;
   q = rq+1;
}
#endif

#ifdef UTRANSFORMLATTICETERM
void utransformlatticeterm_(){
   register cont *rq = q;
register AFFIX A_2 = (rq+0)-> a;
register AFFIX A_1 = (rq+-1)-> a;
register AFFIX A_0 = (rq+-2)-> a;
   char *rc = c;
   if (dtransformlatticeterm_(A_0,A_1,A_2))
   { 
      q=rq-4;
      (*(rq-3)->q)();
      rq=q+3;
   }
   c = rc;
  if (rc > cstore_top ) cstore_overflow();
   (rq+-2)->a = A_0;
   (rq+-1)->a = A_1;
   (rq+0)->a = A_2;
   (rq+1)-> q = utransformlatticeterm_;
   q = rq+1;
}
#endif

#ifdef UTLTRADITIONAL
void utltraditional_(){
   register cont *rq = q;
register AFFIX A_2 = (rq+0)-> a;
register AFFIX A_1 = (rq+-1)-> a;
register AFFIX A_0 = (rq+-2)-> a;
   register char *rc = c;
   char * csave = c;
   int i;
   int x,y   = (long) A_1 -> t;
   x = atoi(A_0->t);
   A_2 ->t = rc;
   A_2 ->r = nil;
   A_2 ->l = nil;
   for (i = 0 ; i <32 ; i++)
      if ( ((1 << i) &  y ) != 0)  {
         register char * rr = groups[x].l[i];
         rc =csave ;
         while  ((rr != 0) && (*rr != '\0'))
            *rc++ =  *rr++;
     if (rr == NULL) {
         fprintf(stderr, 
            "runtime error in tranform lattice: evaluating undefined affix\n");
             exit(1);
        }
         *rc++ = '\0';
         c = rc; 
  if (rc > cstore_top ) cstore_overflow();
         q=rq-4;
         (*(rq-3)->q)();
         rq=q+3;
      }
   c =csave ;
   (rq+-2)->a = A_0;
   (rq+-1)->a = A_1;
   (rq+0)->a = A_2;
   (rq+1)-> q = utltraditional_;
   q = rq+1;
}
#endif

#ifdef UTLTRADITIONALTERM
void utltraditionalterm_(){
   register cont *rq = q;
register AFFIX A_2 = (rq+0)-> a;
register AFFIX A_1 = (rq+-1)-> a;
register AFFIX A_0 = (rq+-2)-> a;
   register char *rc = c;
   char * csave = c;
   int i;
   int x,y   = atoi(A_1 -> t);
   x = atoi(A_0->t);
   A_2 ->t = rc;
   A_2 ->r = nil;
   A_2 ->l = nil;
   for (i = 0 ; i <32 ; i++)
      if ( ((1 << i) &  y ) != 0)  {
         register char * rr = groups[x].l[i];
         rc =csave ;
         while  ((rr != 0) && (*rr != '\0'))
            *rc++ =  *rr++;
     if (rr == NULL) {
         fprintf(stderr, 
            "runtime error in tranform lattice: evaluating undefined affix\n");
             exit(1);
        }
         *rc++ = '\0';
         c = rc; 
  if (rc > cstore_top ) cstore_overflow();
         q=rq-4;
         (*(rq-3)->q)();
         rq=q+3;
      }
   c =csave ;
   (rq+-2)->a = A_0;
   (rq+-1)->a = A_1;
   (rq+0)->a = A_2;
   (rq+1)-> q = utltraditionalterm_;
   q = rq+1;
}
#endif

