/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ge1.h"
#ifdef DTERMINAL
int dterminal_(sterm) 
register char *sterm;
{
  register char  *sp, *term, *rip = ip;
  term = sterm;
  for (; *term != '\0'; rip++)
    if (*term++ != *rip) {
      if ((mip < rip) && (rip < limitip) && (rip > input)) {
        mip = rip;
        change_line_file = true; 
       }
      return false;
    }
  if ((mip < rip) && (rip < limitip) && (rip > input)) {
    mip = rip;
    change_line_file = true; 
  }
  ip = rip;
  return true;
}
#endif


#ifdef DCHOICE
int dchoice_(choice_set,D0) 
  register char  *choice_set;
register AFFIX D0;
{
  register char  *cp = choice_set;
  D0->t = c;
  D0->l = nil;
  D0->r = nil;
  while (*cp != '\0')
    if (*ip == *cp++) {
      *c++ = *ip++;
      *c++ = '\0';
    if (c > cstore_top) cstore_overflow();
      if ((mip < ip) && (ip < limitip) && (ip > input)) {
        mip = ip;
        change_line_file = true; 
      }
      return true;
    }
  return false;
}
#endif

#ifdef DEX_CHOICE
int dex_choice(choice_set,D0) 
  register char  *choice_set;
register AFFIX D0;
{
  register char  *cp = choice_set;
  D0->t = c;
  D0->l = nil;
  D0->r = nil;
  while ((*ip != '\0') && (*ip != *cp))
    if (*cp++ == '\0') {
      *c++ = *ip++;
      *c++ = '\0';
    if (c > cstore_top) cstore_overflow();
      if ((mip < ip) && (ip < limitip) && (ip > input)) {
        mip = ip;
        change_line_file = true; 
      }
      return true;
    }
  return false;
}
#endif


#ifdef DX_STAR_CHOICE
int dx_star_choice(choice_set,D0) 
  register char  *choice_set;
register AFFIX D0;
{
  register char  *cp = choice_set;
  D0->t = c;
  D0->l = nil;
  D0->r = nil;

  while (*cp != '\0')
    if (*ip == *cp++) {
      *c++ = *ip++;
      cp = choice_set;
    }
  *c++ = '\0';
    if (c > cstore_top) cstore_overflow();
  if ((mip < ip) && (ip < limitip) && (ip > input)) {
    mip = ip;
    change_line_file = true; 
  }
  return true; 
}
#endif

#ifdef DX_STAR_EX_CHOICE
int dx_star_ex_choice(choice_set,D0) 
  register char  *choice_set;
register AFFIX D0;
{
  register char  *cp = choice_set, *rip =ip;
  D0->t = c;
  D0->l = nil;
  D0->r = nil;
  if (*cp == '\0') {
    D0->t = rip;
    while (*rip++ != '\0');
    ip = rip-1;
    return true; 
  }
  else { 
    register char *rc = c;
    D0->t = rc;
    while ((*rip != '\0') && (*rip != *cp))
      if (*cp++ == '\0') {
        *rc++ = *rip++;
        cp = choice_set;
      }
    *rc++ = '\0';
    ip = rip;
    c = rc;
    if (c > cstore_top) cstore_overflow();
    if (rc > cstore_top) cstore_overflow();
  }
  if ((mip < ip) && (ip < limitip) && (ip > input)) {
    mip = ip;
    change_line_file = true; 
  }
  return true;
}
#endif


#ifdef DX_PLUS_CHOICE
int dx_plus_choice(choice_set,D0) 
  register char  *choice_set;
register AFFIX D0;
{
  register char  *cp = choice_set, *sip = ip;
  D0->t = c;
  D0->l = nil;
  D0->r = nil;
  while (*cp != '\0')
    if (*ip == *cp++) {
      *c++ = *ip++;
      cp = choice_set;
    }
  if (ip == sip)
    return false;
  *c++ = '\0';
    if (c > cstore_top) cstore_overflow();
  if ((mip < ip) && (ip < limitip) && (ip > input)) {
    mip = ip;
    change_line_file = true; 
  }
  return true;
}
#endif

#ifdef DX_PLUS_EX_CHOICE
int dx_plus_ex_choice(choice_set,D0) 
  register char  *choice_set;
register AFFIX D0;
{
  register char  *cp = choice_set, *sip = ip;
  D0->t = c;
  D0->l = nil;
  D0->r = nil;

  if (*cp == '\0') {
    while (*ip != '\0')
      *c++ = *ip++;
    if (c > cstore_top) cstore_overflow();
    return true;
  } else
    while ((*ip != '\0') && (*ip != *cp))
      if (*cp++ == '\0') {
        *c++ = *ip++;
        cp = choice_set;
      }
  if (ip == sip)
    return false;
  *c++ = '\0';
    if (c > cstore_top) cstore_overflow();
  if ((mip < ip) && (ip < limitip) && (ip > input)) {
    mip = ip;
    change_line_file = true; 
  }
   return true;
}
#endif


#ifdef UTERMINAL
void uterminal_() { 
    register cont *rq = q;
    register char *A_0 = (rq+0)-> s;
    char *sip = ip;
    if ( dterminal_ (A_0))
    {   
        q = rq+-2;
        (*(rq+-1)->q)();
        rq = q +1;
    }   
    ip = sip;
    (rq+0)->s = A_0;
    (rq+1)-> q = uterminal_; 
    q = rq+1; 
}
#endif


#ifdef UCHOICE
void uchoice_() { 
    register cont *rq = q;
    register char *A_0 = (rq+0)-> s;
register AFFIX A_1 = (rq-1)-> a;
    if ( dchoice_(A_0,A_1))
    {   
        q = rq+-3;
        (*(rq+-2)->q)();
        rq = q +2;
    }   
    (rq+-1)->a = A_1;
    (rq+0)->s = A_0;
    (rq+1)-> q = uchoice_; 
    q = rq+1; 
}
#endif

#ifdef UEX_CHOICE
void uex_choice() { 
    register cont *rq = q;
    register char *A_0 = (rq+0)-> s;
register AFFIX A_1 = (rq-1)-> a;
    if ( dex_choice(A_0,A_1))
    {   
        q = rq+-3;
        (*(rq+-2)->q)();
        rq = q +2;
    }   
    (rq+-1)->a = A_1;
    (rq+0)->s = A_0;
    (rq+1)-> q = uex_choice; 
    q = rq+1; 
}
#endif

#ifdef UX_STAR_EX_CHOICE
void ux_star_ex_choice() { 
    register cont *rq = q;
    register char *A_0 = (rq+0)-> s;
register AFFIX A_1 = (rq-1)-> a;
    if ( dx_star_ex_choice(A_0,A_1))
    {   
        q = rq+-3;
        (*(rq+-2)->q)();
        rq = q +2;
    }   
    (rq+-1)->a = A_1;
    (rq+0)->s = A_0;
    (rq+1)-> q = ux_star_ex_choice; 
    q = rq+1; 
}
#endif


#ifdef UX_STAR_CHOICE
void ux_star_choice() { 
    register cont *rq = q;
    register char *A_0 = (rq+0)-> s;
register AFFIX A_1 = (rq-1)-> a;
    if ( dx_star_choice(A_0,A_1))
    {   
        q = rq+-3;
        (*(rq+-2)->q)();
        rq = q +2;
    }   
    (rq+-1)->a = A_1;
    (rq+0)->s = A_0;
    (rq+1)-> q = ux_star_choice; 
    q = rq+1; 
}
#endif

#ifdef UX_PLUS_EX_CHOICE
void ux_plus_ex_choice() { 
    register cont *rq = q;
    register char *A_0 = (rq+0)-> s;
register AFFIX A_1 = (rq-1)-> a;
    if ( dx_plus_ex_choice(A_0,A_1))
    {   
        q = rq+-3;
        (*(rq+-2)->q)();
        rq = q +2;
    }   
    (rq+-1)->a = A_1;
    (rq+0)->s = A_0;
    (rq+1)-> q = ux_plus_ex_choice; 
    q = rq+1; 
}
#endif

#ifdef UX_PLUS_CHOICE
void ux_plus_choice() { 
    register cont *rq = q;
    register char *A_0 = (rq+0)-> s;
register AFFIX A_1 = (rq-1)-> a;
    if ( dx_plus_choice(A_0,A_1))
    {   
        q = rq+-3;
        (*(rq+-2)->q)();
        rq = q +2;
    }   
    (rq+-1)->a = A_1;
    (rq+0)->s = A_0;
    (rq+1)-> q = ux_plus_choice; 
    q = rq+1; 
}
#endif
