/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* file constdef.h : constant definitions and macros */

  
/*     !! IN CASE OF A SIMPLE MAKEFILE SPECIFY DIRECTORIES HERE !! */

#define true    1
#define false   0
#define nil    -2
#define affixnt 0
#define superaffix 1 
#define metaffix 2
#define adp_affix 4
#define factor 8
#define affixtm 16
#define supernt 32 
#define meta_alt 64 
#define mint 128
#define derived 0
#define inherited 1
#define lattice_affix 2
#define nset         32*4   
#define longset      64 *4
#define plusset      128 *4
#define starset     256*4
#define complset    512*4
#define tnode       1024 *4 
#define cnode       2048 *4 
#define lookahead   1  
#define domemo   0  
#define ntnode      0
#define rnode            1
#define docompile          2
#define processing       4
#define notemptyrule     8
#define emptyrule       16
#define deterministic   32
#define nondeterministic   64
#define leftrec            128
#define notleftrec            256
#define recursive            512
#define notrecursive            1024
#define external  4096*8 
#define meta_prod_rule  4096*4
#define meta_One  4
#define meta_OneStar  8
#define meta_Mult  16
#define meta_Super  16
#define meta_Mint  32
#define One 4
#define OneStar 8
#define Mult 16
#define Super 32
#define Lattice  64
#define Mint  164

#define affix_directed_parsing  2
#define no_affix_directed_parsing  1

#define maxnt     4096*4   /* absolute maximum */ 
#define MAX_CHARS  10000  

/* macros */

#define NODENAME(node)      ast[node].n
#define BROTHER(node)       ast[node].b
#define SON(node)           ast[node].s
#define REPR(node)          ast[node].r
#define DEF(node)           ast[node].d
#define LEFTDEF(node)       ast[node].d
#define LINE(node)          (int) ast[node].r

#define MARKED(rule,value)   ((NODENAME (rule) & (value) ) != 0)
#define SET(rule,value)       (NODENAME(rule) ) |= value
#define UNSET(rule,value)     (NODENAME(rule) ) &=  ~ (value )

#define MARKED_ADP(rule,value)   ((DEF(rule) & (value) ) != 0)
#define SET_ADP(rule,value)       (DEF(rule) ) |= value
#define UNSET_ADP(rule,value)     (DEF(rule) ) &=  ~ (value )

#define LATTICE_DEF(node)       ast[node].s
#define INHERITED(node)      (ast[node].n == inherited)
#define DERIVED(node)      (ast[node].n == derived)
#define LATTICE(node)      (ast[node].n == lattice_affix)
#define MEMOIZE(node)     (ast[node].d >= domemo )
#define LKH(node)  MARKED(node,lookahead)
#define NONTERMINAL(member) ((NODENAME (member) ) < 128)
#define TERMINAL(member)    ((NODENAME (member)) >=  128)
#define STRING(member)    ((NODENAME (member) & tnode) == tnode )
#define COMPLEMENT(member)    ((NODENAME (member) & complset) == complset )
#define EXCLAMATIONSTARCHOICE(member)  ((NODENAME(member) & starset) == starset)
#define EXCLAMATIONPLUSCHOICE(member)  ((NODENAME(member) & plusset) == plusset)


#define AFFIXTREE(node)       SON(node)
#define AFFIXDEF(node)       NODENAME(node)
#define OR +
#define LASTALT(alt)         (BROTHER(alt) == nil)

#define IS_LEFTDEF(node)       (ast[node].d != -1)
#define NOT_IS_LEFTDEF(node)   (ast[node].d == -1)

#define META(node)    (ast[node].n == metaffix )
#define FREE_AFFIX(node)    (ast[node].n >= metaffix )
#define APPLY_BOUND_AFFIX(node)    (ast[node].n <  metaffix)
#define DONTCARE(node)  (ast[node].d = 9999)
#define IS_DONTCARE(node)  (ast[node].d == 9999)
#define ISNT_DONTCARE(node)  (ast[node].d != 9999)

#define PART(node)           ast[node].d
#define SUM(node)           ast[node+1].n
#define OLDSUM(node)           ast[node+1].b
#define NEWSUM(node)           ast[node+1].s
#define COUNT(node)           ast[node+1].d

#define SUM_ALT  sum +=   3000001
#define SUM_AFX  sum +=    100022    
#define SUM_MEM  sum +=     91333 
#define SUM_TERM sum +=     15077
#define SUM_DC   sum +=      1125
#define SUM_NOLD sum +=       156
#define SUM_LD   sum +=        19



#include <ctype.h>
#include <stdio.h>
 typedef
struct {
   int n, b, s, d;
   char *r;}
AST;

