/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* file coder2 (for deterministic prefixes) */
#include "gg1.h"
#include "gg2.h"

extern int mems_lifted, highest_tempory, nraffixes;


/* 
 * affix offset count 
 */
int oCount = 0;

det_rule_head()
{
    fprintf(output, "\n\n/*  %s   */\n",REPR(ulhs));
    if (MARKED(ulhs,external)) 
       fprintf(output, "int d%s(", REPR(ulhs));
    else fprintf(output, "static int D_%d(", ulhs);
    det_get_affixes(AFFIXDEF(SON(ulhs)));
    if (fprintf(output, " {\n register AFFIX raf = af;\n") == EOF) {
       fprintf(stderr,"glammar: Write failed (try again later)\n");
       exit(12);
    }
      fprintf(output, "  char *rc = c,  *rip = ip;\n");
    if (lookahead_in_alt(SON(ulhs)))
      fprintf(output, "  char *lkh;\n");
    if (BROTHER(SON(ulhs)) != nil)
      fprintf(output, "  int cut_set = 0;\n");
    if (trace_flag ) 
     fprintf(output, " char *ntname = \"%s\";int ltr=level+1;\n",REPR(ulhs));
    else if (errormsg_flag)  { 
      int mem = SON(SON(ulhs));
      if (mem != nil && DEF(mem) == equal) 
      fprintf(output, 
         "  char *ntname = \"%s\"; int lsave = level+10;\n", REPR(ulhs));
      else fprintf(output, 
         "  char *ntname = \"%s\"; int lsave = level++;\n", REPR(ulhs));
     }
          
    if (stat_flag)  {  
      fprintf(output, "  int s1 = stat_count++;\n");
    }
    save_lattice_afx();
    
}

det_rule_tail() {
    int last_alt;

    for (last_alt = SON(ulhs); BROTHER(last_alt) != nil; 
                                      last_alt =  BROTHER(last_alt)) ;
    if (SON(last_alt) == nil) {
       fprintf(output,"  \n}\n");
       return;
    }

    if (trace_flag) {
       if (errormsg_flag) 
           fprintf(output, "  set_errmsg(ntname);\n");
       fprintf(output, "  level = ltr;endtrace(parsecount,ntname);");
    } 
    else if (errormsg_flag) {
       fprintf(output, "  set_errmsg(ntname);\n");
       fprintf(output, " level = lsave;\n");  
    } 
/*   
 */
  if (stat_flag) 
      fprintf(output, "  stat_tab[%d] += stat_count - s1;\n",COUNT(ulhs));


  fprintf(output,"  return false;\n}\n");
}
     
det_get_affixes(afx)
  int             afx;
{ 
  int affix = afx, count = 0;
   
  if (afx == nil)  {
    fprintf(output, ")\n");
    return;
  } 

  for (; affix != nil; affix = BROTHER(affix)) 
    if (BROTHER (affix) != nil)
       fprintf(output, "A_%d,",count++); 
    else   fprintf(output, "A_%d)\n",count++); 
 
   count = 0; 
   for (affix = afx; affix != nil; affix = BROTHER(affix)) 
    fprintf(output, "  register AFFIX A_%d;\n", count++); 
}


det_rule_alts(alt)
{
  int             affix = (AFFIXDEF(alt)),
                  rule = ulhs;

  if (trace_flag)
    trace_code(affix);
  for (; alt != nil; alt = BROTHER(alt)) {
    
    fprintf(output, "  {\n");
    det_alt_code(alt);
    fprintf(output, "  }\n");
    if (BROTHER (alt) != nil) {
         fprintf(output," ip = rip; c = rc;\n");
         restore_lattice_afx();
       if (trace_flag) {
         fprintf(output, "  if (cut_set) {\n");
         if (stat_flag)
            fprintf(output, "  stat_tab[%d] += stat_count-s1;\n",COUNT(ulhs));
       fprintf(output, "  level = ltr;endtrace(parsecount,ntname);");
       if (errormsg_flag) 
           fprintf(output, "  set_errmsg(ntname);\n");
       fprintf(output," return false;\n}\n");
       } else  {
          if (errormsg_flag) 
              fprintf(output, 
            " if (cut_set) { level=lsave;set_errmsg(ntname);return false;}\n");
          if (stat_flag)
              fprintf(output,
     " if (cut_set) { stat_tab[%d] += stat_count-s1;return false;}\n",COUNT(ulhs));
         else 
             fprintf(output,  " if (cut_set) return false;\n");
       }
    }
  }
}


det_define_all_derived_affixes(alt)
  int             alt;
{
  int             affix, mem;

  for (mem = SON(alt); mem != nil; mem = BROTHER(mem))
    for (affix = AFFIXTREE(mem); affix != nil; affix = BROTHER(affix)) {
      int             term = SON(affix);

      if (NODENAME(affix) == derived)
        if ((APPLY_BOUND_AFFIX(term)) &&   (!IS_LEFTDEF(term)))
          fprintf(output, "  AFFIX  _%s = (raf+%d);\n", REPR(term),++oCount);
      if ( (LATTICE(affix)) && (!IS_LEFTDEF(term)))
          fprintf(output, "  AFFIX  _%s = (raf+%d);\n", REPR(term),++oCount);

    }
}

det_initialize_all_derived_affixes(alt)
  int             alt;
{
  int             affix, mem;

  for (mem = SON(alt); mem != nil; mem = BROTHER(mem))
    for (affix = AFFIXTREE(mem); affix != nil; affix = BROTHER(affix)) {
      int             term = SON(affix);

      if (NODENAME(affix) == derived) {
        if ((IS_LEFTDEF(term)) &&  (NODENAME(term) == affixnt)) {
          if (ISNT_DONTCARE(term))   
             fprintf(output, "   A_%d -> t = undefined;\n", LEFTDEF(term));
        } else
          fprintf(output, "   _%s -> t = undefined;\n", REPR(term));
      }
   }
}


det_nice_lift_tree(lt, rt)
  int             lt, rt;
{
  int             term;

  if (lt == rt)
    return;
  term = BROTHER(lt);
  if (term == rt) {
    if (NODENAME(lt) == affixtm) {
      aCount += 1;
      fprintf(output, "(raf+%d) -> t = \"%s\",(raf+%d) -> l = nil,(raf+%d) -> r = nil,",
        aCount, REPR(lt), aCount, aCount);
    }
    return;
  } else if ((BROTHER(term) == rt) &&  (NODENAME(term) != affixtm)) {
    aCount += 1;
    if (NODENAME(lt) == affixtm) {
      if (IS_LEFTDEF(term))
        fprintf(output, "(raf+%d) -> t = \"%s\",(raf+%d) -> l = nil,(raf+%d) -> r = A_%d,",
          aCount, REPR(lt), aCount, aCount, LEFTDEF(term));
      else if (META(term))
        fprintf(output, "(raf+%d) -> t = \"%s\",(raf+%d) -> l = nil,(raf+%d) -> r = &_%s,",
          aCount, REPR(lt), aCount, aCount, REPR(term));
      else
        fprintf(output, "(raf+%d) -> t = \"%s\",(raf+%d) -> l = nil,(raf+%d) -> r = _%s,",
          aCount, REPR(lt), aCount, aCount, REPR(term));
    } else if (IS_LEFTDEF(lt)) {
      if (IS_LEFTDEF(term))
        fprintf(output, "(raf+%d) -> t = empty,(raf+%d) -> l = A_%d,(raf+%d) -> r = A_%d,",
          aCount, aCount, LEFTDEF(lt), aCount, LEFTDEF(term));
      else if (META(term))
        fprintf(output, "(raf+%d) -> t = empty,(raf+%d) -> l = A_%d,(raf+%d) -> r = &_%s,",
          aCount, aCount, LEFTDEF(lt), aCount, REPR(term));
      else
        fprintf(output, "(raf+%d) -> t = empty,(raf+%d) -> l = A_%d,(raf+%d) -> r = _%s,",
          aCount, aCount, LEFTDEF(lt), aCount, REPR(term));
    } else if (META(lt)) {
      if (IS_LEFTDEF(term))
        fprintf(output, "(raf+%d) -> t = empty,(raf+%d) -> l = &_%s,(raf+%d) -> r = A_%d,",
          aCount, aCount, REPR(lt), aCount, LEFTDEF(term));
      else if (META(term))
        fprintf(output, "(raf+%d) -> t = empty,(raf+%d) -> l = &_%s,(raf+%d) -> r = &_%s,",
          aCount, aCount, REPR(lt), aCount, REPR(term));
      else
        fprintf(output, "(raf+%d) -> t = empty,(raf+%d) -> l = &_%s,(raf+%d) -> r = _%s,",
          aCount, aCount, REPR(lt), aCount, REPR(term));
    } else if (IS_LEFTDEF(term))
      fprintf(output, "(raf+%d) -> t = empty,(raf+%d) -> l = _%s,(raf+%d) -> r = A_%d,",
        aCount, aCount, REPR(lt), aCount, LEFTDEF(term));
    else if (META(term))
      fprintf(output, "(raf+%d) -> t = empty,(raf+%d) -> l = _%s,(raf+%d) -> r = &_%s,",
        aCount, aCount, REPR(lt), aCount, REPR(term));
    else
      fprintf(output, "(raf+%d) -> t = empty,(raf+%d) -> l = _%s,(raf+%d) -> r = _%s,",
        aCount, aCount, REPR(lt), aCount, REPR(term));
    return;
  }
  if (NODENAME(lt) != affixtm) {
    aCount += 1;
    if (IS_LEFTDEF(lt))
      fprintf(output, "(raf+%d) -> t = empty,(raf+%d) -> l = A_%d,(raf+%d) -> r = (raf+%d),",
        aCount, aCount, LEFTDEF(lt), aCount, aCount + 1);
    else if (META(lt))
      fprintf(output, "(raf+%d) -> t = empty,(raf+%d) -> l = /* */ &_%s,(raf+%d) -> r = (raf+%d),",
        aCount, aCount, REPR(lt), aCount, aCount + 1);
    else
      fprintf(output, "(raf+%d) -> t = empty,(raf+%d) -> l = _%s,(raf+%d) -> r = (raf+%d),",
        aCount, aCount, REPR(lt), aCount, aCount + 1);
    det_nice_lift_tree(BROTHER(lt), rt);
  } else {
    aCount += 1;
    fprintf(output, "(raf+%d) -> t = \"%s\",(raf+%d) -> l = nil,(raf+%d) -> r = (raf+%d),",
      aCount, REPR(lt), aCount, aCount, aCount + 1);
    det_nice_lift_tree(BROTHER(lt), rt);
  }
}


det_code_lifted_affixes(affix)
  int             affix;
{
  fprintf(output, "(");
  for (; affix != nil; affix = BROTHER(affix)) {
    int             term = SON(affix);

    if (NODENAME(affix) == inherited) {
      if (BROTHER(term) != nil) {
        int             this_a_count = aCount + 1;

        fprintf(output, "(");
        det_nice_lift_tree(term, nil);
        fprintf(output, "  (raf+%d))", this_a_count);
      } else if (NODENAME(term) == affixtm) {
        aCount += 1;
        fprintf(output, 
         "  ((raf+%d) -> t = \"%s\", (raf+%d) -> l = nil, (raf+%d) -> r = nil,(raf+%d))",
          aCount, REPR(term), aCount, aCount, aCount);
      } else if (IS_LEFTDEF(term))
        fprintf(output, "  A_%d", LEFTDEF(term));
       else if (META(term))
        fprintf(output, "  & _%s", REPR(term));
      else
        fprintf(output, "  _%s", REPR(term));
    } else {
      if (IS_LEFTDEF(term))
        fprintf(output, "  A_%d", LEFTDEF(term));
       else if (META(term))
        fprintf(output, "  & _%s", REPR(term));
      else
        fprintf(output, "  _%s", REPR(term));
    }
    if (BROTHER(affix) != nil)
      fprintf(output, ",");
  }
  fprintf(output, ")");
}


det_result_code(alt)
  int             alt;
{
  int             affix,
                  count = 0;

  for (affix = AFFIXDEF(alt); affix != nil; affix = BROTHER(affix)) {
    if (NODENAME(affix) == derived) {
      int             term = SON(affix);

      if (BROTHER(term) == nil) {
        if (NODENAME(term) == affixtm)
          fprintf(output,
            "  A_%d -> t = \"%s\"; A_%d -> l = nil; A_%d -> r = nil;\n"
            ,count, REPR(term), count, count);
        else if (IS_LEFTDEF(term))
          fprintf(output, "MAKE(A_%d,A_%d);\n ", count, LEFTDEF(term));
        else if (FREE_AFFIX(term)) {
          fprintf(output, "  A_%d ->t  = _%s.t;", count, REPR(term));
          fprintf(output, "A_%d -> r = nil;", count);
          fprintf(output, "A_%d -> l = nil;\n", count);
        }
      } else {
        int             this_a_count = aCount + 1,
                        bterm = BROTHER(term);

        if (BROTHER(bterm) == nil) {
          if ((NODENAME(term) == affixtm) &&  (NODENAME(bterm) == affixtm)) {
            aCount += 1;
            fprintf(output, "  (raf+%d) -> t = \"%s\";", this_a_count, REPR(bterm));
            fprintf(output, "(raf+%d) -> l = nil;", this_a_count);
            fprintf(output, "(raf+%d) -> r = nil;\n", this_a_count);
            fprintf(output, "  A_%d -> t = \"%s\";", count, REPR(term));
            fprintf(output, "A_%d -> r = (raf+%d);", count, this_a_count);
            fprintf(output, "A_%d -> l = nil;", count);
          } else if ((NODENAME(term) != affixtm) && 
            (NODENAME(bterm) == affixtm)) {
            aCount += 1;
            fprintf(output, "  (raf+%d) -> t = \"%s\";", this_a_count, REPR(bterm));
            fprintf(output, "(raf+%d) -> l = nil;", this_a_count);
            fprintf(output, "(raf+%d) -> r = nil;\n", this_a_count);
            if (IS_LEFTDEF(term))
              fprintf(output, "  A_%d -> l = A_%d;", count, LEFTDEF(term));
            else if (META(term))
              fprintf(output, "  A_%d -> l = &_%s;", count, REPR(term));
            else
              fprintf(output, "  A_%d -> l = _%s;", count, REPR(term));
            fprintf(output, "A_%d -> r = (raf+%d);", count, this_a_count);
            fprintf(output, "A_%d -> t = empty;\n", count);
          } else if ((NODENAME(term) == affixtm)  &&
            (NODENAME(bterm) != affixtm)) {
            fprintf(output, "  A_%d -> t = \"%s\";", count, REPR(term));
            if (IS_LEFTDEF(bterm))
              fprintf(output, "A_%d -> r = A_%d;", count, LEFTDEF(bterm));
            else
              fprintf(output, "A_%d -> r = _%s;", count, REPR(bterm));
            fprintf(output, "A_%d -> l = nil;\n", count);
          } else {
            fprintf(output, "  A_%d -> t = empty;", count);
            if (IS_LEFTDEF(term))
              fprintf(output, "A_%d -> l = A_%d;", count, LEFTDEF(term));
            else if (META(term))
              fprintf(output, "A_%d -> l = &_%s;", count, REPR(term));
            else
              fprintf(output, "A_%d -> l = _%s;", count, REPR(term));
            if (IS_LEFTDEF(bterm))
              fprintf(output, "A_%d -> r = A_%d;\n", count, LEFTDEF(bterm));
            else if (META(bterm))
              fprintf(output, "A_%d -> r = /* */ &_%s;\n", count, REPR(bterm));
            else
              fprintf(output, "A_%d -> r = _%s;\n", count, REPR(bterm));
          }
        } else if (NODENAME(term) != affixtm) {
         det_nice_tree(bterm, nil);
          fprintf(output, "  A_%d -> t = empty;", count);
          fprintf(output, "A_%d -> r = (raf+%d);", count, this_a_count);
          if (IS_LEFTDEF(term))
            fprintf(output, "A_%d -> l = A_%d;\n", count, LEFTDEF(term));
          else if (META(term))
            fprintf(output, "A_%d -> l = & _%s;\n", count, REPR(term));
          else
            fprintf(output, "A_%d -> l = _%s;\n", count, REPR(term));
        } else {
          det_nice_tree(bterm, nil);
          fprintf(output, "  A_%d -> t = \"%s\";", count, REPR(term));
          fprintf(output, "A_%d -> r = (raf+%d);", count, this_a_count);
          fprintf(output, "A_%d -> l = nil;\n", count);
        }
      }
    } else if (LATTICE(affix)) 
         if (NODENAME(SON(affix)) == affixtm) {
          int term = SON(affix);
          fprintf(output," A_%d ->t = (char *) 0X%x;\n",count,
              NODENAME(LATTICE_DEF(term)));
         }
    count += 1;
  }
}


det_alt_code(alt)
  int             alt;
{
  int             mem;

  oCount = 0;
  det_alt_intermediate_defs(alt);
  aCount = 0;
  det_define_all_derived_affixes(alt);
  det_initialize_all_derived_affixes(alt);
  if (oCount >0) {
    fprintf (output , " af = (raf+%d);\n",oCount); 
    fprintf (output , " if (af > afx_top ) afx_overflow();\n"); 
  }
  det_lift_code(alt);
  fprintf (output,"   {\n"); 
  det_result_code(alt);
  fprintf (output,"   return true;\n    }\n"); 
}


det_lift_code(alt)
  int             alt;
{
  int             mem = SON(alt);

  mems_lifted = false;
  if ((mem == nil) || (!lift_element(mem)))
    return;
  for (mem = SON(alt); (mem != nil) &&  (lift_element(mem)); mem = BROTHER(mem)) {
    if (LKH(mem))
            fprintf(output, "   if (lkh = ip)\n");
    if (TERMINAL(mem))
      det_code_lifted_terminal(mem, AFFIXTREE(mem));
    else {
      if (DEF(mem) == cut) {
        if (BROTHER(mem) != nil) 
            fprintf(output, "   if (cut_set = 1)\n");
        }
     else if (!MARKED(DEF(mem),external)) {
        fprintf(output, "   if ( D_%d", DEF(mem));
        det_code_lifted_affixes(AFFIXTREE(mem));
        fprintf(output, ")\n");
      }
      else {
        fprintf(output, "   if ( d%s",  REPR(mem));
        det_code_lifted_affixes(AFFIXTREE(mem));
        fprintf(output, ")\n");
      }
    }
    if (LKH(mem))
            fprintf(output, "   if (ip = lkh)\n");
  }
}


det_lkh_epiloque()
{
  fprintf(output, "  if (lkh = 1) \n");
  fprintf(output, "  (rq+%d)->q = kh_epiloque;\n", ++qCount);
}


det_code_lifted_terminal(termi, afx)
  int             termi,
                  afx;
{
  int             trm;

  if (STRING(termi)) {
    fprintf(output, "  if (dterminal_(\"%s\"))\n", REPR(termi));
    return;
  }
  trm = SON(afx);
  if (IS_LEFTDEF(trm)) {
    if (COMPLEMENT(termi)) {
      if (EXCLAMATIONSTARCHOICE(termi))
        fprintf(output, "  if ( dx_star_ex_choice(\"%s\",A_%d))\n",
          REPR(termi), LEFTDEF(trm));
      else if (EXCLAMATIONPLUSCHOICE(termi))
        fprintf(output, "  if (dx_plus_ex_choice(\"%s\",A_%d))\n",
          REPR(termi), LEFTDEF(trm));
      else
        fprintf(output, "  if (dex_choice(\"%s\",A_%d))\n",
          REPR(termi), LEFTDEF(trm));
    } else if (EXCLAMATIONSTARCHOICE(termi))
      fprintf(output, "  if (dx_star_choice(\"%s\",A_%d))\n",
        REPR(termi), LEFTDEF(trm));
    else if (EXCLAMATIONPLUSCHOICE(termi))
      fprintf(output, "  if (dx_plus_choice(\"%s\",A_%d))\n",
        REPR(termi), LEFTDEF(trm));
    else
      fprintf(output, "  if (dchoice_(\"%s\",A_%d))\n",
        REPR(termi), LEFTDEF(trm));
  } else {
    if (COMPLEMENT(termi)) {
      if (EXCLAMATIONSTARCHOICE(termi))
        fprintf(output, "  if (dx_star_ex_choice(\"%s\",_%s))\n",
          REPR(termi), REPR(trm));
      else if (EXCLAMATIONPLUSCHOICE(termi))
        fprintf(output, "  if (dx_plus_ex_choice(\"%s\",_%s))\n",
          REPR(termi), REPR(trm));
      else
        fprintf(output, "  if (dex_choice(\"%s\",_%s))\n",
          REPR(termi), REPR(trm));
    } else if (EXCLAMATIONSTARCHOICE(termi))
      fprintf(output, "  if (dx_star_choice(\"%s\",_%s))\n",
        REPR(termi), REPR(trm));
    else if (EXCLAMATIONPLUSCHOICE(termi))
      fprintf(output, "  if (dx_plus_choice(\"%s\",_%s))\n",
        REPR(termi), REPR(trm));
    else
      fprintf(output, "  if (dchoice_(\"%s\",_%s))\n",
        REPR(termi), REPR(trm));
  }
}


det_alt_intermediate_defs(alt)
  int             alt;

{
  int             mem = SON(alt),
                  count;

  aCount = 0;
  highest_tempory = 0;
  result_intermediate_defs(alt);
  if (mem == nil);
  else if (BROTHER(mem) == nil)
    affix_intermediate_defs(mem);
  else {
    mems_intermediate_defs(BROTHER(mem));
    affix_intermediate_defs(mem);
  }
  if (highest_tempory > aCount)
    aCount = highest_tempory;
   oCount = aCount; 
}

det_nice_tree(lt, rt)
  int             lt, rt;
{
  int             term;

  if (lt == rt)
    return;
  term = BROTHER(lt);
  if (term == rt) {
    if (NODENAME(lt) == affixtm) {
      aCount += 1;
      fprintf(output, "  (raf+%d) ->t = \"%s\"; (raf+%d) ->l = nil; (raf+%d) ->r = nil;\n",
        aCount, REPR(lt), aCount, aCount);
    }
    return;
  } else if ((BROTHER(term) == rt) && (NODENAME(term) != affixtm)) {
    aCount += 1;
    if (NODENAME(lt) == affixtm) {
      if (IS_LEFTDEF(term))
        fprintf(output, "  (raf+%d) ->t = \"%s\"; (raf+%d) ->l = nil; (raf+%d) ->r = A_%d;\n",
          aCount, REPR(lt), aCount, aCount, LEFTDEF(term));
      else if (META(term))
        fprintf(output, "  (raf+%d) ->t = \"%s\"; (raf+%d) ->l = nil; (raf+%d) ->r = &_%s;\n",
          aCount, REPR(lt), aCount, aCount, REPR(term));
      else
        fprintf(output, "  (raf+%d) ->t = \"%s\"; (raf+%d) ->l = nil; (raf+%d) ->r = _%s;\n",
          aCount, REPR(lt), aCount, aCount, REPR(term));
    } else if (IS_LEFTDEF(lt)) {
      if (IS_LEFTDEF(term))
        fprintf(output, "  (raf+%d) ->t = empty; (raf+%d) ->l = A_%d; (raf+%d) ->r =  A_%d;\n",
          aCount, aCount, LEFTDEF(lt), aCount, LEFTDEF(term));
      else if (META(term))
        fprintf(output, "  (raf+%d) ->t = empty; (raf+%d) ->l = A_%d; (raf+%d) ->r = &_%s;\n",
          aCount, aCount, LEFTDEF(lt), aCount, REPR(term));
      else
        fprintf(output, "  (raf+%d) ->t = empty; (raf+%d) ->l = A_%d; (raf+%d) ->r = _%s;\n",
          aCount, aCount, LEFTDEF(lt), aCount, REPR(term));
    } else if (IS_LEFTDEF(term)) {
      if (META(lt))
       fprintf(output, "  (raf+%d) ->t = empty; (raf+%d) ->l = &_%s; (raf+%d) ->r = A_%d;\n",
        aCount, aCount, REPR(lt), aCount, LEFTDEF(term));
       else 
         fprintf(output, "  (raf+%d) ->t = empty; (raf+%d) ->l = _%s; (raf+%d) ->r = A_%d;\n",
        aCount, aCount, REPR(lt), aCount, LEFTDEF(term));
    } else if (META(term)) {
      if (META(lt))
        fprintf(output, "  (raf+%d) ->t = empty; (raf+%d) ->l = &_%s; (raf+%d) ->r = &_%s;\n",
        aCount, aCount, REPR(lt), aCount, REPR(term));
      else 
        fprintf(output, "  (raf+%d) ->t = empty; (raf+%d) ->l = _%s; (raf+%d) ->r = &_%s;\n",
        aCount, aCount, REPR(lt), aCount, REPR(term));
     } else {
      if (META(lt))
      fprintf(output, "  (raf+%d) ->t = empty; (raf+%d) ->l = &_%s; (raf+%d) ->r = _%s;\n",
        aCount, aCount, REPR(lt), aCount, REPR(term));
      else 
        fprintf(output, "  (raf+%d) ->t = empty; (raf+%d) ->l = _%s; (raf+%d) ->r = _%s;\n",
        aCount, aCount, REPR(lt), aCount, REPR(term));
    } 
    return;
  }
  if (NODENAME(lt) != affixtm) {
    aCount += 1;
    if (IS_LEFTDEF(lt))
      fprintf(output, "  (raf+%d) ->t = empty;(raf+%d) ->l = A_%d;(raf+%d) ->r = (raf+%d);\n",
        aCount, aCount, LEFTDEF(lt), aCount, aCount + 1);
    else if (META(lt))
      fprintf(output, "  (raf+%d) ->t = empty;(raf+%d) ->l = &_%s;(raf+%d) ->r = (raf+%d);\n",
        aCount, aCount, REPR(lt), aCount, aCount + 1);
    else
      fprintf(output, "  (raf+%d) ->t = empty;(raf+%d) ->l = _%s;(raf+%d) ->r = (raf+%d);\n",
        aCount, aCount, REPR(lt), aCount, aCount + 1);
    det_nice_tree(BROTHER(lt), rt);
  } else {
    aCount += 1;
    fprintf(output, "  (raf+%d) ->t = \"%s\";(raf+%d) ->l = nil;(raf+%d) ->r = (raf+%d);\n",
      aCount, REPR(lt), aCount, aCount, aCount + 1);
    det_nice_tree(BROTHER(lt), rt);
  }
}



nondet_code() {
    if (MARKED(ulhs,external)) 
       fprintf(output, "void u%s () { register cont *rq = q;\n",REPR(ulhs));
    else
       fprintf(output, "static void U_%d(){register cont *rq = q;\n",ulhs);
    fprintf(output, "char *rc =c , *rip = ip;\n");
    get_affixes(AFFIXDEF(SON(ulhs)),0);
    qCount = nraffixes;
    if (MARKED(ulhs,external)) 
        fprintf(output,"  if (d%s(",REPR(ulhs));
    else
        fprintf(output,"  if (D_%d(",ulhs);
    det_call(AFFIXDEF(SON(ulhs)));
    if (memo_flag) 
   fprintf(output, "  { q=rq+%d;(*(rq+%d)->q)();rq=q- %d;}\n", 
     qCount - 1, qCount,qCount);
    else 
  fprintf(output, "  { q = rq+%d;(*(rq+%d)->q)();}\n", qCount - 1, qCount);
    fprintf(output, "c  = rc; ip =rip;\n");
     push_affixes(AFFIXDEF(SON(ulhs)),0);
    if (MARKED(ulhs,external)) 
     fprintf(output, "  (rq+1)-> q = u%s; q = rq+1; }\n", REPR(ulhs));
    else
     fprintf(output, "  (rq+1)-> q = U_%d; q = rq+1; }\n", ulhs);
}

det_call(afx)
  int             afx;
{ 
  int affix = afx, count = 0;
   
  if (afx == nil)  {
    fprintf(output, "))");
    return;
  } 

  for (; affix != nil; affix = BROTHER(affix)) 
    if (BROTHER (affix) != nil)
       fprintf(output, "A_%d,",count++); 
    else   fprintf(output, "A_%d))\n",count++); 
}

nondet_builtin_code() {
       int ulhs;
       for ( ulhs = laststdpred ; ulhs != nil; ulhs = BROTHER(ulhs)) {
       fprintf(output, "void u%s () { register cont *rq = q;\n",REPR(ulhs));
       get_affixes(AFFIXDEF(SON(ulhs)),0);
       qCount = nraffixes;
       fprintf(output,"  if ( d%s (",REPR(ulhs));
       det_call(AFFIXDEF(SON(ulhs)));
       fprintf(output,"  { \n");
       fprintf(output, "  q = rq+ %d;(*(rq+%d)->q)(); rq = q- %d;\n", 
              qCount - 1, qCount, qCount);
       fprintf(output,"  } \n");
       push_affixes(AFFIXDEF(SON(ulhs)),0);
       fprintf(output, "  (rq+1)-> q = u%s; q = rq+1; }\n\n", REPR(ulhs));
}
}
statistic_table() {
       int ulhs,rule;
       NtCount = 0;
       for (rule = root; rule != laststdpred ; rule = BROTHER (rule))
       COUNT(rule) = NtCount++; 
       if (!MARKED(root,docompile) )
            fprintf(output, "extern ");
       fprintf(output, "int stat_tab[%d], stat_count;\n",NtCount); 
       if (!MARKED(root,docompile))  return;
       fprintf(output, "char * name_tab[%d] = { \"%s\"",NtCount,
                 REPR(root)); 
       for ( ulhs = BROTHER(root) ; ulhs != laststdpred; ulhs = BROTHER(ulhs)) {
            fprintf(output,",\n  \"%s\"",REPR(ulhs));
       }
       fprintf(output,"  \n};\n");
       
       fprintf(output,"print_stat() { \n int nr = 0;\n\
  for (;nr <= %d; nr++) {\n\
  printf(\"%%d.%%s -> %%d\\n\",nr,name_tab[nr], stat_tab[nr]);}\n}",
         NtCount-1);
}

save_lattice_afx()
{ 
  int affix = AFFIXDEF(SON(ulhs)),count = 0;
   for (; affix != nil; count++,affix = BROTHER(affix)) 
     if (LATTICE(affix))
       fprintf(output, "  char *LA_%d = A_%d ->t;\n", count,count); 
}

restore_lattice_afx()
{ 
  int affix = AFFIXDEF(SON(ulhs)), count = 0;
   for (; affix != nil; count++,affix = BROTHER(affix)) 
    if (LATTICE(affix))
     fprintf(output, "  A_%d->t = LA_%d;\n", count,count); 
}
