
/*

    This file is a part of the GLASS source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  S.J. Klaver, R Doesborg
              email: simon@sagan.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* File gconst.h
   Constants for GLUE program
*/

/* Constants for terminal */
#define NORMAL 0
#define REVERSE 1
#define BOLD 2
#define LINELENGTH 80
#define KEY_ESCAPE 27
#define KEY_RETURN 13

/* Line number of the menu, 0 is the first line */
#define MENULINE 2


/* PWIN0 and PWIN1 are the corners of the parameter window.
   PORG is the origin of the list of parameters.
   PARMLINE is the first line of the parameter window when a parameter
     window is used together with a menu
   PARMLINEPAR is the first line of the parameter window if nothing
     else is on the screen
*/

#define PARMLINE 4
#define PARMLINEPAR 1
#define PWINX0 0
#define PWINY0 0
#define PWINX1 77
#define PWINY1 15
#define PORGX  PWINX0+4
#define PORGY  PWINY0+2
#define PACCEPTX PWINX0+2
#define PRESTOREX PWINX0+20
#define ACCEPTSTR " Accept "
#define RESTORESTR " Restore "

/*  If AUTOADVANCE is defined, the menu advances automatically
    after a String, Integer or Real is changed.
*/
