/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* File: fprstr.c
 * C. van Reeuwijk
 */
#include <stdio.h>
#include <ctype.h>

#include "tmc.h"

#define BACKSLASH '\\'

/* definition of 'print' for a 'string' */
void fprint_string( f, s )
 register FILE *f;
 register char *s;
{
    register int c;

    if( s == (char *)0 ){
	fputs( "<nil>", f );
	return;
    }
    putc( '"', f );
    while( *s != '\0' ){
	c = *s++;
	while( c<0 ) c += 256;
	if( c == BACKSLASH || c == '"' ){
	    putc( BACKSLASH, f );
	    putc( c, f );
	    continue;
	}
	if( c>=' ' && c<='~' ){
	    putc( c, f );
	    continue;
	}
	switch( c ){
	    case '\b': putc( BACKSLASH, f ); putc( 'b', f ); break;
	    case '\f': putc( BACKSLASH, f ); putc( 'f', f ); break;
	    case '\n': putc( BACKSLASH, f ); putc( 'n', f ); break;
	    case '\r': putc( BACKSLASH, f ); putc( 'r', f ); break;
	    case '\t': putc( BACKSLASH, f ); putc( 't', f ); break;
	    case '\v': putc( BACKSLASH, f ); putc( 'v', f ); break;
	    default:
		fprintf( f, "\\%03o", (c & 0xff) );
	}
    }
    putc( '"', f );
}
