/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* File: fscstr.c
 * 
 * Handle 'fscan_<type>' for type 'string'.
 */

/* Standard libraries */
#include <ctype.h>
#include <stdio.h>

/* Header of the library this code is part of. */
#include "tmc.h"
#include "config.h"

int fscan_tmbool( f, s )
 FILE *f;
 tmbool *s;
{
    char buf[20];
    int braccnt;
    int err;

    braccnt = fscanopenbrac( f );
    err = fscancons( f, buf );
    if( err ) return( err );
    if( strcmp( buf, TMFALSESTR ) == 0 ){
	*s = TMFALSE;
    }
    else if( strcmp( buf, TMTRUESTR ) == 0 ){
	*s = TMTRUE;
    }
    else {
	(void) strcpy( tmerrmsg, "boolean expected" );
	return( 1 );
    }
    return( fscanclosebrac( f, braccnt ) );
}

