/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* File: fsccons.c
 * Last modified: CvR
 *
 * Reading of constructor names.
 */

/* Standard UNIX libraries. */
#include <stdio.h>
#include <ctype.h>

/* The header of this library */
#include "tmc.h"
#include "config.h"

/* Try to read a constructor name in buffer `buf' */
int fscancons( f, buf )
 FILE *f;
 char *buf;
{
    int c;
    char *p;
    char charstr[15];

    p = buf;
    if( fscanspace( f ) ) return( 1 );
    c = getc( f );
    while( isalnum( c ) ){
	*p++ = c;
	c = getc( f );
    }
    ungetc( c, f );
    *p = '\0';
    if( p == buf ){
	if( c == EOF ){
	    (void) sprintf( charstr, "EOF" );
	}
	else if( c>=' ' && c<='~' ){
	    (void) sprintf( charstr, "char '%c'", c );
	}
	else {
	    (void) sprintf( charstr, "char 0x%02x", c );
	}
	(void) sprintf( tmerrmsg, "Expected constructor name but got %s", charstr );
	return( 1 );
    }
    return( 0 );
}
